/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class GarbageCollectionPrepareResponse {
    public static final String SERIALIZED_NAME_RUN_ID = "run_id";
    @SerializedName(value="run_id")
    private String runId;
    public static final String SERIALIZED_NAME_GC_COMMITS_LOCATION = "gc_commits_location";
    @SerializedName(value="gc_commits_location")
    private String gcCommitsLocation;
    public static final String SERIALIZED_NAME_GC_ADDRESSES_LOCATION = "gc_addresses_location";
    @SerializedName(value="gc_addresses_location")
    private String gcAddressesLocation;

    public GarbageCollectionPrepareResponse runId(String runId) {
        this.runId = runId;
        return this;
    }

    @ApiModelProperty(example="64eaa103-d726-4a33-bcb8-7c0b4abfe09e", required=true, value="a unique identifier generated for this GC job")
    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public GarbageCollectionPrepareResponse gcCommitsLocation(String gcCommitsLocation) {
        this.gcCommitsLocation = gcCommitsLocation;
        return this;
    }

    @ApiModelProperty(example="s3://my-storage-namespace/_lakefs/retention/commits", required=true, value="location of the resulting commits csv table (partitioned by run_id)")
    public String getGcCommitsLocation() {
        return this.gcCommitsLocation;
    }

    public void setGcCommitsLocation(String gcCommitsLocation) {
        this.gcCommitsLocation = gcCommitsLocation;
    }

    public GarbageCollectionPrepareResponse gcAddressesLocation(String gcAddressesLocation) {
        this.gcAddressesLocation = gcAddressesLocation;
        return this;
    }

    @ApiModelProperty(example="s3://my-storage-namespace/_lakefs/retention/addresses", required=true, value="location to use for expired addresses parquet table (partitioned by run_id)")
    public String getGcAddressesLocation() {
        return this.gcAddressesLocation;
    }

    public void setGcAddressesLocation(String gcAddressesLocation) {
        this.gcAddressesLocation = gcAddressesLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GarbageCollectionPrepareResponse garbageCollectionPrepareResponse = (GarbageCollectionPrepareResponse)o;
        return Objects.equals(this.runId, garbageCollectionPrepareResponse.runId) && Objects.equals(this.gcCommitsLocation, garbageCollectionPrepareResponse.gcCommitsLocation) && Objects.equals(this.gcAddressesLocation, garbageCollectionPrepareResponse.gcAddressesLocation);
    }

    public int hashCode() {
        return Objects.hash(this.runId, this.gcCommitsLocation, this.gcAddressesLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GarbageCollectionPrepareResponse {\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    gcCommitsLocation: ").append(this.toIndentedString(this.gcCommitsLocation)).append("\n");
        sb.append("    gcAddressesLocation: ").append(this.toIndentedString(this.gcAddressesLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

