/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.Commit;
import io.lakefs.clients.api.model.CommitCreation;
import io.lakefs.clients.api.model.CommitList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CommitsApi {
    private ApiClient localVarApiClient;

    public CommitsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CommitsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call commitCall(String repository, String branch, CommitCreation commitCreation, ApiCallback _callback) throws ApiException {
        CommitCreation localVarPostBody = commitCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/commits".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call commitValidateBeforeCall(String repository, String branch, CommitCreation commitCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling commit(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling commit(Async)");
        }
        if (commitCreation == null) {
            throw new ApiException("Missing the required parameter 'commitCreation' when calling commit(Async)");
        }
        Call localVarCall = this.commitCall(repository, branch, commitCreation, _callback);
        return localVarCall;
    }

    public Commit commit(String repository, String branch, CommitCreation commitCreation) throws ApiException {
        ApiResponse<Commit> localVarResp = this.commitWithHttpInfo(repository, branch, commitCreation);
        return localVarResp.getData();
    }

    public ApiResponse<Commit> commitWithHttpInfo(String repository, String branch, CommitCreation commitCreation) throws ApiException {
        Call localVarCall = this.commitValidateBeforeCall(repository, branch, commitCreation, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call commitAsync(String repository, String branch, CommitCreation commitCreation, ApiCallback<Commit> _callback) throws ApiException {
        Call localVarCall = this.commitValidateBeforeCall(repository, branch, commitCreation, _callback);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommitCall(String repository, String commitId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/commits/{commitId}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{commitId\\}", this.localVarApiClient.escapeString(commitId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommitValidateBeforeCall(String repository, String commitId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getCommit(Async)");
        }
        if (commitId == null) {
            throw new ApiException("Missing the required parameter 'commitId' when calling getCommit(Async)");
        }
        Call localVarCall = this.getCommitCall(repository, commitId, _callback);
        return localVarCall;
    }

    public Commit getCommit(String repository, String commitId) throws ApiException {
        ApiResponse<Commit> localVarResp = this.getCommitWithHttpInfo(repository, commitId);
        return localVarResp.getData();
    }

    public ApiResponse<Commit> getCommitWithHttpInfo(String repository, String commitId) throws ApiException {
        Call localVarCall = this.getCommitValidateBeforeCall(repository, commitId, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommitAsync(String repository, String commitId, ApiCallback<Commit> _callback) throws ApiException {
        Call localVarCall = this.getCommitValidateBeforeCall(repository, commitId, _callback);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call logBranchCommitsCall(String repository, String branch, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/commits".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call logBranchCommitsValidateBeforeCall(String repository, String branch, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling logBranchCommits(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling logBranchCommits(Async)");
        }
        Call localVarCall = this.logBranchCommitsCall(repository, branch, after, amount, _callback);
        return localVarCall;
    }

    @Deprecated
    public CommitList logBranchCommits(String repository, String branch, String after, Integer amount) throws ApiException {
        ApiResponse<CommitList> localVarResp = this.logBranchCommitsWithHttpInfo(repository, branch, after, amount);
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<CommitList> logBranchCommitsWithHttpInfo(String repository, String branch, String after, Integer amount) throws ApiException {
        Call localVarCall = this.logBranchCommitsValidateBeforeCall(repository, branch, after, amount, null);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call logBranchCommitsAsync(String repository, String branch, String after, Integer amount, ApiCallback<CommitList> _callback) throws ApiException {
        Call localVarCall = this.logBranchCommitsValidateBeforeCall(repository, branch, after, amount, _callback);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

