/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.PrepareGCUncommittedRequest;
import io.lakefs.clients.api.model.PrepareGCUncommittedResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RetentionApi {
    private ApiClient localVarApiClient;

    public RetentionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RetentionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call prepareGarbageCollectionCommitsCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/prepare_commits".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionCommitsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionCommits(Async)");
        }
        Call localVarCall = this.prepareGarbageCollectionCommitsCall(repository, _callback);
        return localVarCall;
    }

    public GarbageCollectionPrepareResponse prepareGarbageCollectionCommits(String repository) throws ApiException {
        ApiResponse<GarbageCollectionPrepareResponse> localVarResp = this.prepareGarbageCollectionCommitsWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<GarbageCollectionPrepareResponse> prepareGarbageCollectionCommitsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call prepareGarbageCollectionCommitsAsync(String repository, ApiCallback<GarbageCollectionPrepareResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call prepareGarbageCollectionUncommittedCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        PrepareGCUncommittedRequest localVarPostBody = prepareGCUncommittedRequest;
        String localVarPath = "/repositories/{repository}/gc/prepare_uncommited".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionUncommittedValidateBeforeCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionUncommitted(Async)");
        }
        Call localVarCall = this.prepareGarbageCollectionUncommittedCall(repository, prepareGCUncommittedRequest, _callback);
        return localVarCall;
    }

    public PrepareGCUncommittedResponse prepareGarbageCollectionUncommitted(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        ApiResponse<PrepareGCUncommittedResponse> localVarResp = this.prepareGarbageCollectionUncommittedWithHttpInfo(repository, prepareGCUncommittedRequest);
        return localVarResp.getData();
    }

    public ApiResponse<PrepareGCUncommittedResponse> prepareGarbageCollectionUncommittedWithHttpInfo(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, null);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call prepareGarbageCollectionUncommittedAsync(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback<PrepareGCUncommittedResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, _callback);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

