/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api;

import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.ProgressRequestBody;
import io.lakefs.clients.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.api.model.Error;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.PrepareGCUncommittedRequest;
import io.lakefs.clients.api.model.PrepareGCUncommittedResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RetentionApi {
    private ApiClient localVarApiClient;

    public RetentionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RetentionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for prepareGarbageCollectionCommits
     * @param repository  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call prepareGarbageCollectionCommitsCall(String repository, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/gc/prepare_commits"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call prepareGarbageCollectionCommitsValidateBeforeCall(String repository, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionCommits(Async)");
        }
        

        okhttp3.Call localVarCall = prepareGarbageCollectionCommitsCall(repository, _callback);
        return localVarCall;

    }

    /**
     * save lists of active commits for garbage collection
     * 
     * @param repository  (required)
     * @return GarbageCollectionPrepareResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public GarbageCollectionPrepareResponse prepareGarbageCollectionCommits(String repository) throws ApiException {
        ApiResponse<GarbageCollectionPrepareResponse> localVarResp = prepareGarbageCollectionCommitsWithHttpInfo(repository);
        return localVarResp.getData();
    }

    /**
     * save lists of active commits for garbage collection
     * 
     * @param repository  (required)
     * @return ApiResponse&lt;GarbageCollectionPrepareResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GarbageCollectionPrepareResponse> prepareGarbageCollectionCommitsWithHttpInfo(String repository) throws ApiException {
        okhttp3.Call localVarCall = prepareGarbageCollectionCommitsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * save lists of active commits for garbage collection (asynchronously)
     * 
     * @param repository  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call prepareGarbageCollectionCommitsAsync(String repository, final ApiCallback<GarbageCollectionPrepareResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = prepareGarbageCollectionCommitsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for prepareGarbageCollectionUncommitted
     * @param repository  (required)
     * @param prepareGCUncommittedRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call prepareGarbageCollectionUncommittedCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = prepareGCUncommittedRequest;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/gc/prepare_uncommited"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call prepareGarbageCollectionUncommittedValidateBeforeCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionUncommitted(Async)");
        }
        

        okhttp3.Call localVarCall = prepareGarbageCollectionUncommittedCall(repository, prepareGCUncommittedRequest, _callback);
        return localVarCall;

    }

    /**
     * save repository uncommitted metadata for garbage collection
     * 
     * @param repository  (required)
     * @param prepareGCUncommittedRequest  (optional)
     * @return PrepareGCUncommittedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public PrepareGCUncommittedResponse prepareGarbageCollectionUncommitted(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        ApiResponse<PrepareGCUncommittedResponse> localVarResp = prepareGarbageCollectionUncommittedWithHttpInfo(repository, prepareGCUncommittedRequest);
        return localVarResp.getData();
    }

    /**
     * save repository uncommitted metadata for garbage collection
     * 
     * @param repository  (required)
     * @param prepareGCUncommittedRequest  (optional)
     * @return ApiResponse&lt;PrepareGCUncommittedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PrepareGCUncommittedResponse> prepareGarbageCollectionUncommittedWithHttpInfo(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        okhttp3.Call localVarCall = prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, null);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * save repository uncommitted metadata for garbage collection (asynchronously)
     * 
     * @param repository  (required)
     * @param prepareGCUncommittedRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> paths to commit dataset </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call prepareGarbageCollectionUncommittedAsync(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, final ApiCallback<PrepareGCUncommittedResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, _callback);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
