/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.ImportCreation;
import io.lakefs.clients.api.model.ImportCreationResponse;
import io.lakefs.clients.api.model.ImportStatusResp;
import io.lakefs.clients.api.model.IngestRangeCreationResponse;
import io.lakefs.clients.api.model.MetaRangeCreation;
import io.lakefs.clients.api.model.MetaRangeCreationResponse;
import io.lakefs.clients.api.model.StageRangeCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ImportApi {
    private ApiClient localVarApiClient;

    public ImportApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImportApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createMetaRangeCall(String repository, MetaRangeCreation metaRangeCreation, ApiCallback _callback) throws ApiException {
        MetaRangeCreation localVarPostBody = metaRangeCreation;
        String localVarPath = "/repositories/{repository}/branches/metaranges".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMetaRangeValidateBeforeCall(String repository, MetaRangeCreation metaRangeCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createMetaRange(Async)");
        }
        if (metaRangeCreation == null) {
            throw new ApiException("Missing the required parameter 'metaRangeCreation' when calling createMetaRange(Async)");
        }
        Call localVarCall = this.createMetaRangeCall(repository, metaRangeCreation, _callback);
        return localVarCall;
    }

    public MetaRangeCreationResponse createMetaRange(String repository, MetaRangeCreation metaRangeCreation) throws ApiException {
        ApiResponse<MetaRangeCreationResponse> localVarResp = this.createMetaRangeWithHttpInfo(repository, metaRangeCreation);
        return localVarResp.getData();
    }

    public ApiResponse<MetaRangeCreationResponse> createMetaRangeWithHttpInfo(String repository, MetaRangeCreation metaRangeCreation) throws ApiException {
        Call localVarCall = this.createMetaRangeValidateBeforeCall(repository, metaRangeCreation, null);
        Type localVarReturnType = new TypeToken<MetaRangeCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMetaRangeAsync(String repository, MetaRangeCreation metaRangeCreation, ApiCallback<MetaRangeCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.createMetaRangeValidateBeforeCall(repository, metaRangeCreation, _callback);
        Type localVarReturnType = new TypeToken<MetaRangeCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importCancelCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importCancelValidateBeforeCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importCancel(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importCancel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling importCancel(Async)");
        }
        Call localVarCall = this.importCancelCall(repository, branch, id, _callback);
        return localVarCall;
    }

    public void importCancel(String repository, String branch, String id) throws ApiException {
        this.importCancelWithHttpInfo(repository, branch, id);
    }

    public ApiResponse<Void> importCancelWithHttpInfo(String repository, String branch, String id) throws ApiException {
        Call localVarCall = this.importCancelValidateBeforeCall(repository, branch, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call importCancelAsync(String repository, String branch, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.importCancelValidateBeforeCall(repository, branch, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call importStartCall(String repository, String branch, ImportCreation importCreation, ApiCallback _callback) throws ApiException {
        ImportCreation localVarPostBody = importCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importStartValidateBeforeCall(String repository, String branch, ImportCreation importCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importStart(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importStart(Async)");
        }
        if (importCreation == null) {
            throw new ApiException("Missing the required parameter 'importCreation' when calling importStart(Async)");
        }
        Call localVarCall = this.importStartCall(repository, branch, importCreation, _callback);
        return localVarCall;
    }

    public ImportCreationResponse importStart(String repository, String branch, ImportCreation importCreation) throws ApiException {
        ApiResponse<ImportCreationResponse> localVarResp = this.importStartWithHttpInfo(repository, branch, importCreation);
        return localVarResp.getData();
    }

    public ApiResponse<ImportCreationResponse> importStartWithHttpInfo(String repository, String branch, ImportCreation importCreation) throws ApiException {
        Call localVarCall = this.importStartValidateBeforeCall(repository, branch, importCreation, null);
        Type localVarReturnType = new TypeToken<ImportCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importStartAsync(String repository, String branch, ImportCreation importCreation, ApiCallback<ImportCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.importStartValidateBeforeCall(repository, branch, importCreation, _callback);
        Type localVarReturnType = new TypeToken<ImportCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importStatusCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importStatusValidateBeforeCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importStatus(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importStatus(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling importStatus(Async)");
        }
        Call localVarCall = this.importStatusCall(repository, branch, id, _callback);
        return localVarCall;
    }

    public ImportStatusResp importStatus(String repository, String branch, String id) throws ApiException {
        ApiResponse<ImportStatusResp> localVarResp = this.importStatusWithHttpInfo(repository, branch, id);
        return localVarResp.getData();
    }

    public ApiResponse<ImportStatusResp> importStatusWithHttpInfo(String repository, String branch, String id) throws ApiException {
        Call localVarCall = this.importStatusValidateBeforeCall(repository, branch, id, null);
        Type localVarReturnType = new TypeToken<ImportStatusResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importStatusAsync(String repository, String branch, String id, ApiCallback<ImportStatusResp> _callback) throws ApiException {
        Call localVarCall = this.importStatusValidateBeforeCall(repository, branch, id, _callback);
        Type localVarReturnType = new TypeToken<ImportStatusResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call ingestRangeCall(String repository, StageRangeCreation stageRangeCreation, ApiCallback _callback) throws ApiException {
        StageRangeCreation localVarPostBody = stageRangeCreation;
        String localVarPath = "/repositories/{repository}/branches/ranges".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call ingestRangeValidateBeforeCall(String repository, StageRangeCreation stageRangeCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling ingestRange(Async)");
        }
        if (stageRangeCreation == null) {
            throw new ApiException("Missing the required parameter 'stageRangeCreation' when calling ingestRange(Async)");
        }
        Call localVarCall = this.ingestRangeCall(repository, stageRangeCreation, _callback);
        return localVarCall;
    }

    public IngestRangeCreationResponse ingestRange(String repository, StageRangeCreation stageRangeCreation) throws ApiException {
        ApiResponse<IngestRangeCreationResponse> localVarResp = this.ingestRangeWithHttpInfo(repository, stageRangeCreation);
        return localVarResp.getData();
    }

    public ApiResponse<IngestRangeCreationResponse> ingestRangeWithHttpInfo(String repository, StageRangeCreation stageRangeCreation) throws ApiException {
        Call localVarCall = this.ingestRangeValidateBeforeCall(repository, stageRangeCreation, null);
        Type localVarReturnType = new TypeToken<IngestRangeCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call ingestRangeAsync(String repository, StageRangeCreation stageRangeCreation, ApiCallback<IngestRangeCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.ingestRangeValidateBeforeCall(repository, stageRangeCreation, _callback);
        Type localVarReturnType = new TypeToken<IngestRangeCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

