/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Commit {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PARENTS = "parents";
    @SerializedName(value="parents")
    private List<String> parents = new ArrayList<String>();
    public static final String SERIALIZED_NAME_COMMITTER = "committer";
    @SerializedName(value="committer")
    private String committer;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private Long creationDate;
    public static final String SERIALIZED_NAME_META_RANGE_ID = "meta_range_id";
    @SerializedName(value="meta_range_id")
    private String metaRangeId;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;

    public Commit id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Commit parents(List<String> parents) {
        this.parents = parents;
        return this;
    }

    public Commit addParentsItem(String parentsItem) {
        this.parents.add(parentsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public Commit committer(String committer) {
        this.committer = committer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public Commit message(String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Commit creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unix Epoch in seconds")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Commit metaRangeId(String metaRangeId) {
        this.metaRangeId = metaRangeId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getMetaRangeId() {
        return this.metaRangeId;
    }

    public void setMetaRangeId(String metaRangeId) {
        this.metaRangeId = metaRangeId;
    }

    public Commit metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Commit putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return Objects.equals(this.id, commit.id) && Objects.equals(this.parents, commit.parents) && Objects.equals(this.committer, commit.committer) && Objects.equals(this.message, commit.message) && Objects.equals(this.creationDate, commit.creationDate) && Objects.equals(this.metaRangeId, commit.metaRangeId) && Objects.equals(this.metadata, commit.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parents, this.committer, this.message, this.creationDate, this.metaRangeId, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Commit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parents: ").append(this.toIndentedString(this.parents)).append("\n");
        sb.append("    committer: ").append(this.toIndentedString(this.committer)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    metaRangeId: ").append(this.toIndentedString(this.metaRangeId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

