/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StageRangeCreation {
    public static final String SERIALIZED_NAME_FROM_SOURCE_U_R_I = "fromSourceURI";
    @SerializedName(value="fromSourceURI")
    private String fromSourceURI;
    public static final String SERIALIZED_NAME_AFTER = "after";
    @SerializedName(value="after")
    private String after;
    public static final String SERIALIZED_NAME_PREPEND = "prepend";
    @SerializedName(value="prepend")
    private String prepend;
    public static final String SERIALIZED_NAME_CONTINUATION_TOKEN = "continuation_token";
    @SerializedName(value="continuation_token")
    private String continuationToken;
    public static final String SERIALIZED_NAME_STAGING_TOKEN = "staging_token";
    @SerializedName(value="staging_token")
    private String stagingToken;

    public StageRangeCreation fromSourceURI(String fromSourceURI) {
        this.fromSourceURI = fromSourceURI;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="s3://my-bucket/production/collections/", required=true, value="The source location of the ingested files. Must match the lakeFS installation blockstore type.")
    public String getFromSourceURI() {
        return this.fromSourceURI;
    }

    public void setFromSourceURI(String fromSourceURI) {
        this.fromSourceURI = fromSourceURI;
    }

    public StageRangeCreation after(String after) {
        this.after = after;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="production/collections/some/file.parquet", required=true, value="Only objects after this key would be ingested.")
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public StageRangeCreation prepend(String prepend) {
        this.prepend = prepend;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="collections/", required=true, value="A prefix to prepend to ingested objects.")
    public String getPrepend() {
        return this.prepend;
    }

    public void setPrepend(String prepend) {
        this.prepend = prepend;
    }

    public StageRangeCreation continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Opaque. Client should pass the continuation_token received from server to continue creation ranges from the same key.")
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public StageRangeCreation stagingToken(String stagingToken) {
        this.stagingToken = stagingToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Opaque. Client should pass staging_token if received from server on previous request")
    public String getStagingToken() {
        return this.stagingToken;
    }

    public void setStagingToken(String stagingToken) {
        this.stagingToken = stagingToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageRangeCreation stageRangeCreation = (StageRangeCreation)o;
        return Objects.equals(this.fromSourceURI, stageRangeCreation.fromSourceURI) && Objects.equals(this.after, stageRangeCreation.after) && Objects.equals(this.prepend, stageRangeCreation.prepend) && Objects.equals(this.continuationToken, stageRangeCreation.continuationToken) && Objects.equals(this.stagingToken, stageRangeCreation.stagingToken);
    }

    public int hashCode() {
        return Objects.hash(this.fromSourceURI, this.after, this.prepend, this.continuationToken, this.stagingToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StageRangeCreation {\n");
        sb.append("    fromSourceURI: ").append(this.toIndentedString(this.fromSourceURI)).append("\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    prepend: ").append(this.toIndentedString(this.prepend)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    stagingToken: ").append(this.toIndentedString(this.stagingToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

