/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OtfDiffEntry {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_OPERATION_CONTENT = "operation_content";
    @SerializedName(value="operation_content")
    private Object operationContent;
    public static final String SERIALIZED_NAME_OPERATION_TYPE = "operation_type";
    @SerializedName(value="operation_type")
    private OperationTypeEnum operationType;

    public OtfDiffEntry id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OtfDiffEntry timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public OtfDiffEntry operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public OtfDiffEntry operationContent(Object operationContent) {
        this.operationContent = operationContent;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="free form content describing the returned operation diff")
    public Object getOperationContent() {
        return this.operationContent;
    }

    public void setOperationContent(Object operationContent) {
        this.operationContent = operationContent;
    }

    public OtfDiffEntry operationType(OperationTypeEnum operationType) {
        this.operationType = operationType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the operation category (CUD)")
    public OperationTypeEnum getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtfDiffEntry otfDiffEntry = (OtfDiffEntry)o;
        return Objects.equals(this.id, otfDiffEntry.id) && Objects.equals(this.timestamp, otfDiffEntry.timestamp) && Objects.equals(this.operation, otfDiffEntry.operation) && Objects.equals(this.operationContent, otfDiffEntry.operationContent) && Objects.equals((Object)this.operationType, (Object)otfDiffEntry.operationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.timestamp, this.operation, this.operationContent, this.operationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtfDiffEntry {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    operationContent: ").append(this.toIndentedString(this.operationContent)).append("\n");
        sb.append("    operationType: ").append(this.toIndentedString((Object)this.operationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperationTypeEnum {
        CREATE("create"),
        UPDATE("update"),
        DELETE("delete");

        private String value;

        private OperationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperationTypeEnum fromValue(String value) {
            for (OperationTypeEnum b : OperationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperationTypeEnum> {
            public void write(JsonWriter jsonWriter, OperationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperationTypeEnum.fromValue(value);
            }
        }
    }
}

