/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GarbageCollectionPrepareResponse {
    public static final String SERIALIZED_NAME_RUN_ID = "run_id";
    @SerializedName(value="run_id")
    private String runId;
    public static final String SERIALIZED_NAME_GC_COMMITS_LOCATION = "gc_commits_location";
    @SerializedName(value="gc_commits_location")
    private String gcCommitsLocation;
    public static final String SERIALIZED_NAME_GC_ADDRESSES_LOCATION = "gc_addresses_location";
    @SerializedName(value="gc_addresses_location")
    private String gcAddressesLocation;
    public static final String SERIALIZED_NAME_GC_COMMITS_PRESIGNED_URL = "gc_commits_presigned_url";
    @SerializedName(value="gc_commits_presigned_url")
    private String gcCommitsPresignedUrl;

    public GarbageCollectionPrepareResponse runId(String runId) {
        this.runId = runId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="64eaa103-d726-4a33-bcb8-7c0b4abfe09e", required=true, value="a unique identifier generated for this GC job")
    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public GarbageCollectionPrepareResponse gcCommitsLocation(String gcCommitsLocation) {
        this.gcCommitsLocation = gcCommitsLocation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="s3://my-storage-namespace/_lakefs/retention/commits", required=true, value="location of the resulting commits csv table (partitioned by run_id)")
    public String getGcCommitsLocation() {
        return this.gcCommitsLocation;
    }

    public void setGcCommitsLocation(String gcCommitsLocation) {
        this.gcCommitsLocation = gcCommitsLocation;
    }

    public GarbageCollectionPrepareResponse gcAddressesLocation(String gcAddressesLocation) {
        this.gcAddressesLocation = gcAddressesLocation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="s3://my-storage-namespace/_lakefs/retention/addresses", required=true, value="location to use for expired addresses parquet table (partitioned by run_id)")
    public String getGcAddressesLocation() {
        return this.gcAddressesLocation;
    }

    public void setGcAddressesLocation(String gcAddressesLocation) {
        this.gcAddressesLocation = gcAddressesLocation;
    }

    public GarbageCollectionPrepareResponse gcCommitsPresignedUrl(String gcCommitsPresignedUrl) {
        this.gcCommitsPresignedUrl = gcCommitsPresignedUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="a presigned url to download the commits csv")
    public String getGcCommitsPresignedUrl() {
        return this.gcCommitsPresignedUrl;
    }

    public void setGcCommitsPresignedUrl(String gcCommitsPresignedUrl) {
        this.gcCommitsPresignedUrl = gcCommitsPresignedUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GarbageCollectionPrepareResponse garbageCollectionPrepareResponse = (GarbageCollectionPrepareResponse)o;
        return Objects.equals(this.runId, garbageCollectionPrepareResponse.runId) && Objects.equals(this.gcCommitsLocation, garbageCollectionPrepareResponse.gcCommitsLocation) && Objects.equals(this.gcAddressesLocation, garbageCollectionPrepareResponse.gcAddressesLocation) && Objects.equals(this.gcCommitsPresignedUrl, garbageCollectionPrepareResponse.gcCommitsPresignedUrl);
    }

    public int hashCode() {
        return Objects.hash(this.runId, this.gcCommitsLocation, this.gcAddressesLocation, this.gcCommitsPresignedUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GarbageCollectionPrepareResponse {\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    gcCommitsLocation: ").append(this.toIndentedString(this.gcCommitsLocation)).append("\n");
        sb.append("    gcAddressesLocation: ").append(this.toIndentedString(this.gcAddressesLocation)).append("\n");
        sb.append("    gcCommitsPresignedUrl: ").append(this.toIndentedString(this.gcCommitsPresignedUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

