/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class TemplatesApi {
    private ApiClient localVarApiClient;

    public TemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call expandTemplateCall(String templateLocation, Map<String, String> params, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/templates/{template_location}".replaceAll("\\{template_location\\}", this.localVarApiClient.escapeString(templateLocation.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (params != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("params", params));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"*/*", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call expandTemplateValidateBeforeCall(String templateLocation, Map<String, String> params, ApiCallback _callback) throws ApiException {
        if (templateLocation == null) {
            throw new ApiException("Missing the required parameter 'templateLocation' when calling expandTemplate(Async)");
        }
        Call localVarCall = this.expandTemplateCall(templateLocation, params, _callback);
        return localVarCall;
    }

    public Object expandTemplate(String templateLocation, Map<String, String> params) throws ApiException {
        ApiResponse<Object> localVarResp = this.expandTemplateWithHttpInfo(templateLocation, params);
        return localVarResp.getData();
    }

    public ApiResponse<Object> expandTemplateWithHttpInfo(String templateLocation, Map<String, String> params) throws ApiException {
        Call localVarCall = this.expandTemplateValidateBeforeCall(templateLocation, params, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call expandTemplateAsync(String templateLocation, Map<String, String> params, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.expandTemplateValidateBeforeCall(templateLocation, params, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

