/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.OTFDiffs;
import io.lakefs.clients.api.model.OtfDiffList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentalApi {
    private ApiClient localVarApiClient;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getOtfDiffsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/otf/diffs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOtfDiffsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getOtfDiffsCall(_callback);
        return localVarCall;
    }

    public OTFDiffs getOtfDiffs() throws ApiException {
        ApiResponse<OTFDiffs> localVarResp = this.getOtfDiffsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<OTFDiffs> getOtfDiffsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOtfDiffsAsync(ApiCallback<OTFDiffs> _callback) throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call otfDiffCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/otf/refs/{left_ref}/diff/{right_ref}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{left_ref\\}", this.localVarApiClient.escapeString(leftRef.toString())).replaceAll("\\{right_ref\\}", this.localVarApiClient.escapeString(rightRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tablePath != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("table_path", tablePath));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call otfDiffValidateBeforeCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling otfDiff(Async)");
        }
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling otfDiff(Async)");
        }
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling otfDiff(Async)");
        }
        if (tablePath == null) {
            throw new ApiException("Missing the required parameter 'tablePath' when calling otfDiff(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling otfDiff(Async)");
        }
        Call localVarCall = this.otfDiffCall(repository, leftRef, rightRef, tablePath, type, _callback);
        return localVarCall;
    }

    public OtfDiffList otfDiff(String repository, String leftRef, String rightRef, String tablePath, String type) throws ApiException {
        ApiResponse<OtfDiffList> localVarResp = this.otfDiffWithHttpInfo(repository, leftRef, rightRef, tablePath, type);
        return localVarResp.getData();
    }

    public ApiResponse<OtfDiffList> otfDiffWithHttpInfo(String repository, String leftRef, String rightRef, String tablePath, String type) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, null);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call otfDiffAsync(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback<OtfDiffList> _callback) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, _callback);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

