/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoginConfig {
    public static final String SERIALIZED_NAME_R_B_A_C = "RBAC";
    @SerializedName(value="RBAC")
    private RBACEnum RBAC;
    public static final String SERIALIZED_NAME_LOGIN_URL = "login_url";
    @SerializedName(value="login_url")
    private String loginUrl;
    public static final String SERIALIZED_NAME_LOGIN_FAILED_MESSAGE = "login_failed_message";
    @SerializedName(value="login_failed_message")
    private String loginFailedMessage;
    public static final String SERIALIZED_NAME_FALLBACK_LOGIN_URL = "fallback_login_url";
    @SerializedName(value="fallback_login_url")
    private String fallbackLoginUrl;
    public static final String SERIALIZED_NAME_FALLBACK_LOGIN_LABEL = "fallback_login_label";
    @SerializedName(value="fallback_login_label")
    private String fallbackLoginLabel;
    public static final String SERIALIZED_NAME_LOGIN_COOKIE_NAMES = "login_cookie_names";
    @SerializedName(value="login_cookie_names")
    private List<String> loginCookieNames = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LOGOUT_URL = "logout_url";
    @SerializedName(value="logout_url")
    private String logoutUrl;

    public LoginConfig RBAC(RBACEnum RBAC) {
        this.RBAC = RBAC;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RBAC will remain enabled on GUI if \"external\".  That only works with an external auth service. ")
    public RBACEnum getRBAC() {
        return this.RBAC;
    }

    public void setRBAC(RBACEnum RBAC) {
        this.RBAC = RBAC;
    }

    public LoginConfig loginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="primary URL to use for login.")
    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public LoginConfig loginFailedMessage(String loginFailedMessage) {
        this.loginFailedMessage = loginFailedMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="message to display to users who fail to login; a full sentence that is rendered in HTML and may contain a link to a secondary login method ")
    public String getLoginFailedMessage() {
        return this.loginFailedMessage;
    }

    public void setLoginFailedMessage(String loginFailedMessage) {
        this.loginFailedMessage = loginFailedMessage;
    }

    public LoginConfig fallbackLoginUrl(String fallbackLoginUrl) {
        this.fallbackLoginUrl = fallbackLoginUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="secondary URL to offer users to use for login.")
    public String getFallbackLoginUrl() {
        return this.fallbackLoginUrl;
    }

    public void setFallbackLoginUrl(String fallbackLoginUrl) {
        this.fallbackLoginUrl = fallbackLoginUrl;
    }

    public LoginConfig fallbackLoginLabel(String fallbackLoginLabel) {
        this.fallbackLoginLabel = fallbackLoginLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="label to place on fallback_login_url.")
    public String getFallbackLoginLabel() {
        return this.fallbackLoginLabel;
    }

    public void setFallbackLoginLabel(String fallbackLoginLabel) {
        this.fallbackLoginLabel = fallbackLoginLabel;
    }

    public LoginConfig loginCookieNames(List<String> loginCookieNames) {
        this.loginCookieNames = loginCookieNames;
        return this;
    }

    public LoginConfig addLoginCookieNamesItem(String loginCookieNamesItem) {
        this.loginCookieNames.add(loginCookieNamesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="cookie names used to store JWT")
    public List<String> getLoginCookieNames() {
        return this.loginCookieNames;
    }

    public void setLoginCookieNames(List<String> loginCookieNames) {
        this.loginCookieNames = loginCookieNames;
    }

    public LoginConfig logoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="URL to use for logging out.")
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginConfig loginConfig = (LoginConfig)o;
        return Objects.equals((Object)this.RBAC, (Object)loginConfig.RBAC) && Objects.equals(this.loginUrl, loginConfig.loginUrl) && Objects.equals(this.loginFailedMessage, loginConfig.loginFailedMessage) && Objects.equals(this.fallbackLoginUrl, loginConfig.fallbackLoginUrl) && Objects.equals(this.fallbackLoginLabel, loginConfig.fallbackLoginLabel) && Objects.equals(this.loginCookieNames, loginConfig.loginCookieNames) && Objects.equals(this.logoutUrl, loginConfig.logoutUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.RBAC, this.loginUrl, this.loginFailedMessage, this.fallbackLoginUrl, this.fallbackLoginLabel, this.loginCookieNames, this.logoutUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginConfig {\n");
        sb.append("    RBAC: ").append(this.toIndentedString((Object)this.RBAC)).append("\n");
        sb.append("    loginUrl: ").append(this.toIndentedString(this.loginUrl)).append("\n");
        sb.append("    loginFailedMessage: ").append(this.toIndentedString(this.loginFailedMessage)).append("\n");
        sb.append("    fallbackLoginUrl: ").append(this.toIndentedString(this.fallbackLoginUrl)).append("\n");
        sb.append("    fallbackLoginLabel: ").append(this.toIndentedString(this.fallbackLoginLabel)).append("\n");
        sb.append("    loginCookieNames: ").append(this.toIndentedString(this.loginCookieNames)).append("\n");
        sb.append("    logoutUrl: ").append(this.toIndentedString(this.logoutUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RBACEnum {
        SIMPLIFIED("simplified"),
        EXTERNAL("external");

        private String value;

        private RBACEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RBACEnum fromValue(String value) {
            for (RBACEnum b : RBACEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RBACEnum> {
            public void write(JsonWriter jsonWriter, RBACEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RBACEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RBACEnum.fromValue(value);
            }
        }
    }
}

