/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.CommitList;
import io.lakefs.clients.api.model.DiffList;
import io.lakefs.clients.api.model.FindMergeBaseResult;
import io.lakefs.clients.api.model.Merge;
import io.lakefs.clients.api.model.MergeResult;
import io.lakefs.clients.api.model.RefsDump;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RefsApi {
    private ApiClient localVarApiClient;

    public RefsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RefsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call diffRefsCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{leftRef}/diff/{rightRef}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{leftRef\\}", this.localVarApiClient.escapeString(leftRef.toString())).replaceAll("\\{rightRef\\}", this.localVarApiClient.escapeString(rightRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (delimiter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delimiter", delimiter));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call diffRefsValidateBeforeCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffRefs(Async)");
        }
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling diffRefs(Async)");
        }
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling diffRefs(Async)");
        }
        Call localVarCall = this.diffRefsCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        return localVarCall;
    }

    public DiffList diffRefs(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        ApiResponse<DiffList> localVarResp = this.diffRefsWithHttpInfo(repository, leftRef, rightRef, after, amount, prefix, delimiter, type);
        return localVarResp.getData();
    }

    public ApiResponse<DiffList> diffRefsWithHttpInfo(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        Call localVarCall = this.diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call diffRefsAsync(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback<DiffList> _callback) throws ApiException {
        Call localVarCall = this.diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call dumpRefsCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/dump".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dumpRefsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling dumpRefs(Async)");
        }
        Call localVarCall = this.dumpRefsCall(repository, _callback);
        return localVarCall;
    }

    public RefsDump dumpRefs(String repository) throws ApiException {
        ApiResponse<RefsDump> localVarResp = this.dumpRefsWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<RefsDump> dumpRefsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call dumpRefsAsync(String repository, ApiCallback<RefsDump> _callback) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findMergeBaseCall(String repository, String sourceRef, String destinationBranch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{sourceRef\\}", this.localVarApiClient.escapeString(sourceRef.toString())).replaceAll("\\{destinationBranch\\}", this.localVarApiClient.escapeString(destinationBranch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findMergeBaseValidateBeforeCall(String repository, String sourceRef, String destinationBranch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling findMergeBase(Async)");
        }
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling findMergeBase(Async)");
        }
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling findMergeBase(Async)");
        }
        Call localVarCall = this.findMergeBaseCall(repository, sourceRef, destinationBranch, _callback);
        return localVarCall;
    }

    public FindMergeBaseResult findMergeBase(String repository, String sourceRef, String destinationBranch) throws ApiException {
        ApiResponse<FindMergeBaseResult> localVarResp = this.findMergeBaseWithHttpInfo(repository, sourceRef, destinationBranch);
        return localVarResp.getData();
    }

    public ApiResponse<FindMergeBaseResult> findMergeBaseWithHttpInfo(String repository, String sourceRef, String destinationBranch) throws ApiException {
        Call localVarCall = this.findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, null);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findMergeBaseAsync(String repository, String sourceRef, String destinationBranch, ApiCallback<FindMergeBaseResult> _callback) throws ApiException {
        Call localVarCall = this.findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, _callback);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call logCommitsCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/commits".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{ref\\}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (objects != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "objects", objects));
        }
        if (prefixes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prefixes", prefixes));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (firstParent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("first_parent", firstParent));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logCommitsValidateBeforeCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling logCommits(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling logCommits(Async)");
        }
        Call localVarCall = this.logCommitsCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        return localVarCall;
    }

    public CommitList logCommits(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent) throws ApiException {
        ApiResponse<CommitList> localVarResp = this.logCommitsWithHttpInfo(repository, ref, after, amount, objects, prefixes, limit, firstParent);
        return localVarResp.getData();
    }

    public ApiResponse<CommitList> logCommitsWithHttpInfo(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent) throws ApiException {
        Call localVarCall = this.logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, null);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call logCommitsAsync(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback<CommitList> _callback) throws ApiException {
        Call localVarCall = this.logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call mergeIntoBranchCall(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback _callback) throws ApiException {
        Merge localVarPostBody = merge;
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{sourceRef\\}", this.localVarApiClient.escapeString(sourceRef.toString())).replaceAll("\\{destinationBranch\\}", this.localVarApiClient.escapeString(destinationBranch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call mergeIntoBranchValidateBeforeCall(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling mergeIntoBranch(Async)");
        }
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling mergeIntoBranch(Async)");
        }
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling mergeIntoBranch(Async)");
        }
        Call localVarCall = this.mergeIntoBranchCall(repository, sourceRef, destinationBranch, merge, _callback);
        return localVarCall;
    }

    public MergeResult mergeIntoBranch(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        ApiResponse<MergeResult> localVarResp = this.mergeIntoBranchWithHttpInfo(repository, sourceRef, destinationBranch, merge);
        return localVarResp.getData();
    }

    public ApiResponse<MergeResult> mergeIntoBranchWithHttpInfo(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        Call localVarCall = this.mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, null);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call mergeIntoBranchAsync(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback<MergeResult> _callback) throws ApiException {
        Call localVarCall = this.mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, _callback);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restoreRefsCall(String repository, RefsDump refsDump, ApiCallback _callback) throws ApiException {
        RefsDump localVarPostBody = refsDump;
        String localVarPath = "/repositories/{repository}/refs/restore".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreRefsValidateBeforeCall(String repository, RefsDump refsDump, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling restoreRefs(Async)");
        }
        if (refsDump == null) {
            throw new ApiException("Missing the required parameter 'refsDump' when calling restoreRefs(Async)");
        }
        Call localVarCall = this.restoreRefsCall(repository, refsDump, _callback);
        return localVarCall;
    }

    public void restoreRefs(String repository, RefsDump refsDump) throws ApiException {
        this.restoreRefsWithHttpInfo(repository, refsDump);
    }

    public ApiResponse<Void> restoreRefsWithHttpInfo(String repository, RefsDump refsDump) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsDump, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restoreRefsAsync(String repository, RefsDump refsDump, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsDump, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

