/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.lang.reflect.Field;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.EncryptorsCustom;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="key-spec")
public class KeySpecProperties {
    private String salt;
    private int iterationCount = 1024;
    private int keyLength = 256;
    private String algorithm = "PBKDF2WithHmacSHA1";
    private String cipherAlgorithm = "CBC";

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public TextEncryptor getTextEncryptor(String data) {
        RsaSecretEncryptor encryptor;
        if (data.contains("RSA PRIVATE KEY")) {
            try {
                encryptor = new RsaSecretEncryptor(data);
            }
            catch (IllegalArgumentException e) {
                throw new KeyFormatException();
            }
        } else {
            if (data.startsWith("ssh-rsa") || data.contains("RSA PUBLIC KEY")) {
                throw new KeyFormatException();
            }
            encryptor = EncryptorsCustom.text((CharSequence)data, (CharSequence)this.getSalt(), (String)this.cipherAlgorithm, (int)this.iterationCount, (int)this.keyLength, (String)this.algorithm);
        }
        return encryptor;
    }

    public String getSalt() {
        if (StringUtils.hasText((String)this.salt)) {
            return this.salt;
        }
        Field field = ReflectionUtils.findField(EncryptorFactory.class, (String)"SALT");
        ReflectionUtils.makeAccessible((Field)field);
        Object salt = ReflectionUtils.getField((Field)field, null);
        Assert.isInstanceOf(String.class, (Object)salt, (String)"SALT expected");
        return (String)salt;
    }
}

