/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.view;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.web.view.ExpressionCollector;
import org.springframework.boot.web.view.ExpressionResolver;
import org.springframework.boot.web.view.NonRecursivePropertyPlaceholderHelper;
import org.springframework.expression.Expression;
import org.springframework.web.servlet.View;

public class TemplateView
implements View {
    private final NonRecursivePropertyPlaceholderHelper helper = new NonRecursivePropertyPlaceholderHelper("${", "}");
    private final String template;
    private volatile Map<String, Expression> expressions;

    public TemplateView(String template) {
        this.template = template;
    }

    public String getContentType() {
        return "text/html";
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (response.getContentType() == null) {
            response.setContentType(this.getContentType());
        }
        String result = this.toString(model);
        response.getWriter().append(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Expression> getExpressions() {
        if (this.expressions == null) {
            TemplateView templateView = this;
            synchronized (templateView) {
                ExpressionCollector expressionCollector = new ExpressionCollector();
                this.helper.replacePlaceholders(this.template, expressionCollector);
                this.expressions = expressionCollector.getExpressions();
            }
        }
        return this.expressions;
    }

    public String toString(Map<String, ?> model) {
        HashMap map = new HashMap(model);
        ExpressionResolver resolver = new ExpressionResolver(this.getExpressions(), map);
        return this.helper.replacePlaceholders(this.template, resolver);
    }
}

