/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MediaTypeUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${apple-app-site-association.path:/apple-app-site-association}"})
public class AppleAppSiteAssociationController
implements ResourceLoaderAware {
    private final ResourceProperties resourceProperties;
    private ResourceLoader resourceLoader;

    public AppleAppSiteAssociationController(ResourceProperties resourceProperties) {
        this.resourceProperties = resourceProperties;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @RequestMapping
    public HttpEntity<?> appleAppSiteAssociation() {
        ArrayList<String> list = new ArrayList<String>();
        for (String staticLocation : this.resourceProperties.getStaticLocations()) {
            if (!staticLocation.endsWith("/")) {
                staticLocation = staticLocation + "/";
            }
            list.add(staticLocation + "apple-app-site-association.json");
            list.add(staticLocation + "apple-app-site-association.xml");
            list.add(staticLocation + "apple-app-site-association.html");
        }
        Resource resource = this.getResource(list.toArray(new String[list.size()]));
        if (resource == null) {
            return ResponseEntity.ok(Collections.emptyMap());
        }
        MediaType mediaType = MediaTypeUtils.parseMediaType((Resource)resource);
        return ResponseEntity.ok().contentType(mediaType).body((Object)resource);
    }

    public Resource getResource(String ... locations) {
        for (String location : locations) {
            Resource resource = this.resourceLoader.getResource(location);
            try {
                if (!resource.exists()) continue;
                resource.getURL();
                return resource;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

