/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@ConditionalOnClass(value={PlatformTransactionManager.class})
@AutoConfigureAfter(value={TransactionAutoConfiguration.class})
public class TransactionAutoConfigurationAfter {
    @Bean(name={"org.springframework.transaction.config.internalTransactionAdvisor"})
    @Role(value=2)
    @ConfigurationProperties(value="transaction.advisor")
    public AspectJExpressionPointcutAdvisor transactionAdvisor(@Qualifier(value="transactionInterceptor") TransactionInterceptor transactionInterceptor) {
        String expression = "execution(* repository..*Service.*(..)) || execution(* repository.jpa..*Repository.*(..)) || execution(* com.repository..*Service.*(..)) || execution(* com.repository..*Repository.*(..)) || execution(* org.springframework.data.repository..*Repository.*(..)) || execution(* org.springframework.data.jpa.repository.support..*Repository.*(..)) || execution(* org.springframework.batch.core.repository..*Repository.*(..)) || execution(* org.springframework.batch.core.repository.support..*Repository.*(..))";
        AspectJExpressionPointcutAdvisor aspectJExpressionPointcutAdvisor = new AspectJExpressionPointcutAdvisor();
        aspectJExpressionPointcutAdvisor.setExpression(expression);
        aspectJExpressionPointcutAdvisor.setAdvice((Advice)transactionInterceptor);
        return aspectJExpressionPointcutAdvisor;
    }

    @Bean
    @Role(value=2)
    @ConfigurationProperties(value="transaction.interceptor")
    public TransactionInterceptor transactionInterceptor(@Qualifier(value="transactionManager") PlatformTransactionManager transactionManager, TransactionAttributeSource ... transactionAttributeSources) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager(transactionManager);
        transactionInterceptor.setTransactionAttributeSources(transactionAttributeSources);
        return transactionInterceptor;
    }

    @Bean
    @Role(value=2)
    @ConfigurationProperties(value="transaction.attribute-source.name-match")
    public NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource() {
        Properties attribute = new Properties();
        attribute.put("count*", "PROPAGATION_REQUIRED,ISOLATION_READ_UNCOMMITTED,readOnly");
        attribute.put("get*", "PROPAGATION_REQUIRED,ISOLATION_READ_UNCOMMITTED,readOnly");
        attribute.put("find*", "PROPAGATION_REQUIRED,ISOLATION_READ_UNCOMMITTED,readOnly");
        attribute.put("exist*", "PROPAGATION_REQUIRED,ISOLATION_READ_UNCOMMITTED,readOnly");
        attribute.put("load*", "PROPAGATION_REQUIRED,ISOLATION_READ_UNCOMMITTED,readOnly");
        attribute.put("*", "PROPAGATION_REQUIRED,ISOLATION_READ_COMMITTED");
        NameMatchTransactionAttributeSource transactionAttributeSource = new NameMatchTransactionAttributeSource();
        transactionAttributeSource.setProperties(attribute);
        return transactionAttributeSource;
    }
}

