/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceMultipleProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class DataSourceMultipleAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSourceMultipleListener dataSourceMultipleListener() {
        return new DataSourceMultipleListener();
    }

    protected static class DataSourceMultipleListener
    implements ApplicationListener<ApplicationReadyEvent> {
        private List<DataSourceMultipleProperties> multiple = new ArrayList<DataSourceMultipleProperties>();

        protected DataSourceMultipleListener() {
        }

        public void onApplicationEvent(ApplicationReadyEvent event) {
            for (DataSourceMultipleProperties dataSourceMultipleProperties : this.multiple) {
                event.getApplicationContext().getBeanFactory().registerSingleton(dataSourceMultipleProperties.getName(), (Object)dataSourceMultipleProperties.initializeDataSourceBuilder().build());
            }
        }

        public List<DataSourceMultipleProperties> getMultiple() {
            return this.multiple;
        }

        public void setMultiple(List<DataSourceMultipleProperties> multiple) {
            this.multiple = multiple;
        }
    }
}

