/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceDecorator;
import org.springframework.boot.autoconfigure.jdbc.DataSourceDecoratorProperties;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DataSourceDecoratorPostProcessor
implements BeanPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;
    private final ApplicationContext applicationContext;
    private final DataSourceDecoratorProperties properties;

    DataSourceDecoratorPostProcessor(DataSourceDecoratorProperties properties, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource && !this.properties.getExcludes().contains(beanName)) {
            DataSource dataSource = (DataSource)bean;
            new RelaxedDataBinder((Object)dataSource).bind((PropertyValues)new MutablePropertyValues(this.properties.getProperties()));
            ArrayList decorators = new ArrayList(this.applicationContext.getBeansOfType(DataSourceDecorator.class).values());
            AnnotationAwareOrderComparator.sort(decorators);
            for (DataSourceDecorator decorator : decorators) {
                dataSource = decorator.decorate(dataSource);
            }
            return dataSource;
        }
        return bean;
    }

    public int getOrder() {
        return this.order;
    }
}

