/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.web;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolverCustom;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={PageableHandlerMethodArgumentResolver.class, WebMvcConfigurerAdapter.class})
@AutoConfigureBefore(value={SpringDataWebAutoConfiguration.class})
public class SpringDataWebAutoConfigurationBefore {
    @Bean
    @Primary
    public PageableHandlerMethodArgumentResolver pageableResolver() {
        return new PageableHandlerMethodArgumentResolverCustom(this.sortResolver());
    }

    @Bean
    @Primary
    public SortHandlerMethodArgumentResolver sortResolver() {
        return new SortHandlerMethodArgumentResolver();
    }

    @Bean
    public DomainClassConverter<FormattingConversionService> domainClassConverter(FormattingConversionService formattingConversionService, ApplicationContext applicationContext) {
        DomainClassConverter converter = new DomainClassConverter((ConversionService)formattingConversionService);
        converter.setApplicationContext(applicationContext);
        return converter;
    }
}

