/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.KeyGeneratorImpl;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnBean(value={CacheAspectSupport.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.cache", name={"auto"}, havingValue="true", matchIfMissing=true)
public class CacheAutoConfigurationAfter
implements CachingConfigurer {
    private final CacheManager cacheManager;

    @Autowired
    public CacheAutoConfigurationAfter(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new KeyGeneratorImpl();
    }

    @Bean
    public CacheResolver cacheResolver() {
        return new SimpleCacheResolver(this.cacheManager);
    }

    @Bean
    public CacheErrorHandler errorHandler() {
        return new SimpleCacheErrorHandler();
    }

    public CacheManager cacheManager() {
        return this.cacheManager;
    }
}

