/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.info;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class RequestInfoContributor
implements InfoContributor {
    private final boolean requestContext = ClassUtils.isPresent((String)"org.springframework.web.context.request.RequestContextHolder", (ClassLoader)this.getClass().getClassLoader());

    public void contribute(Info.Builder builder) {
        HttpServletRequest httpServletRequest;
        if (this.requestContext && (httpServletRequest = this.getRequest()) != null) {
            LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(httpServletRequest);
            LinkedHashMap<String, InetSocketAddress> address = new LinkedHashMap<String, InetSocketAddress>();
            address.put("local", servletServerHttpRequest.getLocalAddress());
            address.put("remote", servletServerHttpRequest.getRemoteAddress());
            address.put("server", InetSocketAddress.createUnresolved(httpServletRequest.getServerName(), httpServletRequest.getServerPort()));
            request.put("address", address);
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            for (Map.Entry entry : servletServerHttpRequest.getHeaders().entrySet()) {
                String headerName = (String)entry.getKey();
                String headerValue = "Cookie".equalsIgnoreCase(headerName) ? StringUtils.collectionToDelimitedString((Collection)((Collection)entry.getValue()), (String)"; ") : StringUtils.collectionToCommaDelimitedString((Collection)((Collection)entry.getValue()));
                header.put(headerName, headerValue);
            }
            request.put("header", header);
            request.put("secure", httpServletRequest.isSecure());
            request.put("contextPath", httpServletRequest.getContextPath());
            request.put("uri", ServletUriComponentsBuilder.fromRequest((HttpServletRequest)httpServletRequest).build().toUri());
            try {
                request.put("url", servletServerHttpRequest.getURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            request.put("method", servletServerHttpRequest.getMethod());
            builder.withDetail("request", request);
        }
    }

    private HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }
}

