/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.info;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ClassUtils;

public class LocaleInfoContributor
implements InfoContributor {
    private final boolean localeContext = ClassUtils.isPresent((String)"org.springframework.context.i18n.LocaleContextHolder", (ClassLoader)this.getClass().getClassLoader());

    public void contribute(Info.Builder builder) {
        if (this.localeContext) {
            LinkedHashMap<String, Locale> locale = new LinkedHashMap<String, Locale>();
            locale.put("local", Locale.getDefault());
            locale.put("remote", LocaleContextHolder.getLocale());
            builder.withDetail("locale", locale);
            LinkedHashMap<String, TimeZone> timeZone = new LinkedHashMap<String, TimeZone>();
            timeZone.put("local", TimeZone.getDefault());
            timeZone.put("remote", LocaleContextHolder.getTimeZone());
            builder.withDetail("timeZone", timeZone);
        }
    }
}

