package org.springframework.boot.web.filter;

import org.springframework.core.Ordered;
import org.springframework.web.filter.TraceFilter;

/**
 * @see org.springframework.session.web.http.SessionRepositoryFilter#DEFAULT_ORDER
 * @see org.springframework.boot.autoconfigure.security.SecurityProperties#DEFAULT_FILTER_ORDER
 */
public class OrderedTraceFilter extends TraceFilter implements Ordered {
  private int order = -50;

  @Override
  public int getOrder() {
    return order;
  }

  public void setOrder(int order) {
    this.order = order;
  }
}
