package org.springframework.boot.web.filter;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Ordered;
import org.springframework.web.filter.TimeZoneAwareLocaleChangeFilter;
import org.springframework.web.servlet.support.RequestContextUtils;

/**
 * @see RequestContextUtils#getLocaleResolver(HttpServletRequest)
 * @see RequestContextUtils#getLocale(HttpServletRequest)
 * @see LocaleContextHolder#setLocaleContext(org.springframework.context.i18n.LocaleContext)
 * @see org.springframework.beans.propertyeditors.LocaleEditor
 * @see org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext
 * @see org.springframework.web.servlet.i18n.LocaleChangeInterceptor
 * @see org.springframework.web.servlet.support.RequestContextUtils#getLocale(HttpServletRequest)
 * @see org.springframework.session.web.http.SessionRepositoryFilter#DEFAULT_ORDER
 * @see org.springframework.boot.web.servlet.FilterRegistrationBean#REQUEST_WRAPPER_FILTER_MAX_ORDER
 */
public class OrderedTimeZoneAwareLocaleChangeFilter extends TimeZoneAwareLocaleChangeFilter implements Ordered {
  private int order = Ordered.HIGHEST_PRECEDENCE + 150;

  @Override
  public int getOrder() {
    return this.order;
  }

  public void setOrder(int order) {
    this.order = order;
  }
}
