package org.springframework.boot.autoconfigure.web;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Proxy.Type;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "spring.http.client")
public class HttpClientProperties {
  private Type type = Type.DIRECT;
  private InetAddress address = InetAddress.getLoopbackAddress();
  private int port = -1;

  public Type getType() {
    return type;
  }

  public void setType(Type type) {
    this.type = type;
  }

  public InetAddress getAddress() {
    return address;
  }

  public void setAddress(InetAddress address) {
    this.address = address;
  }

  public int getPort() {
    return port;
  }

  public void setPort(int port) {
    this.port = port;
  }

  public Proxy createProxy() {
    if (this.address == null) {
      return Proxy.NO_PROXY;
    }
    try {
      return new Proxy(this.type, InetSocketAddress.createUnresolved(this.address.getHostAddress(), this.port));
    }
    catch (IllegalArgumentException e) {
      return Proxy.NO_PROXY;
    }
  }
}
