package org.springframework.boot.autoconfigure.web;

import javax.servlet.Servlet;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class })
@AutoConfigureBefore(WebMvcAutoConfiguration.class)
@EnableConfigurationProperties(ResourceProperties.class)
@ConditionalOnProperty(prefix = "apple-app-site-association", name = "enabled", matchIfMissing = true)
public class AppleAppSiteAssociationMvcAutoConfiguration {
  @Bean
  public AppleAppSiteAssociationController appleAppSiteAssociationController(ResourceProperties resourceProperties) {
    return new AppleAppSiteAssociationController(resourceProperties);
  }
}
