package org.springframework.boot.autoconfigure.security.oauth2;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerConfigurationAfter;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass({ OAuth2AccessToken.class, WebMvcConfigurerAdapter.class })
@Import({ OAuth2ResourceServerConfigurationAfter.class })
@AutoConfigureBefore(WebMvcAutoConfiguration.class)
@AutoConfigureAfter(OAuth2AutoConfiguration.class)
public class OAuth2AutoConfigurationAfter {

}
