package org.springframework.boot.autoconfigure.security;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyImpl;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyImplCustom;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration
@ConditionalOnClass({ AuthenticationManager.class, GlobalAuthenticationConfigurerAdapter.class })
@AutoConfigureAfter(SecurityAutoConfiguration.class)
public class SecurityAutoConfigurationAfter {
  @Bean
  @ConditionalOnMissingBean(RoleHierarchy.class)
  public RoleHierarchy roleHierarchy() {
    RoleHierarchyImpl roleHierarchyImpl = new RoleHierarchyImplCustom();
    roleHierarchyImpl.setHierarchy("");
    return roleHierarchyImpl;
  }

  @Bean
  @ConditionalOnMissingBean(GrantedAuthorityDefaults.class)
  public GrantedAuthorityDefaults grantedAuthorityDefaults() {
    return new GrantedAuthorityDefaults("");
  }
}
