package org.springframework.boot.autoconfigure.scheduling;

import java.util.concurrent.Executor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

/**
 * @see java.util.concurrent.Executor
 * @see org.springframework.core.task.AsyncTaskExecutor
 */
@ConditionalOnClass(Trigger.class)
@ConditionalOnBean(value = Executor.class, name = "asyncTaskExecutor")
@AutoConfigureAfter(SchedulingAutoConfiguration.class)
@Configuration
@ConditionalOnProperty(prefix = "spring.scheduling", name = "auto", havingValue = "true", matchIfMissing = true)
public class SchedulingAutoConfigurationAfter implements SchedulingConfigurer {
  private final Executor executor;

  @Autowired
  public SchedulingAutoConfigurationAfter(@Qualifier("asyncTaskExecutor") Executor executor) {
    this.executor = executor;
  }

  @Override
  public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
    taskRegistrar.setScheduler(executor);
  }
}
