package org.springframework.boot.autoconfigure.jdbc;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class DataSourceMultipleProperties extends DataSourceProperties {
  private Map<String, String> properties = new HashMap<String, String>();

  public Map<String, String> getProperties() {
    return properties;
  }

  public void setProperties(Map<String, String> properties) {
    this.properties = properties;
  }

  @SuppressWarnings("unchecked")
  @Override
  public DataSourceBuilder initializeDataSourceBuilder() {
    DataSourceBuilder dataSourceBuilder = super.initializeDataSourceBuilder();
    if (!CollectionUtils.isEmpty(this.properties)) {
      Field field = ReflectionUtils.findField(dataSourceBuilder.getClass(), "properties");
      if (field != null) {
        ReflectionUtils.makeAccessible(field);
        Object object = ReflectionUtils.getField(field, dataSourceBuilder);
        if (object instanceof Map) {
          ((Map<Object, Object>) object).putAll(this.properties);
        }
      }
    }
    return dataSourceBuilder;
  }
}