package org.springframework.boot.autoconfigure.jackson;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import com.fasterxml.jackson.databind.ObjectMapper;

@Configuration
@ConditionalOnClass(ObjectMapper.class)
@AutoConfigureAfter({ JacksonAutoConfiguration.class })
public class JacksonAutoConfigurationAfter {
  @Bean
  public Jackson2ObjectMapperBuilderCustomizer findModulesViaServiceLoader() {
    return new Jackson2ObjectMapperBuilderCustomizer() {
      @Override
      public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        jacksonObjectMapperBuilder.findModulesViaServiceLoader(true);
      }
    };
  }

  @Bean
  public Jackson2ObjectMapperBuilderCustomizer mixIn() {
    return new Jackson2ObjectMapperBuilderCustomizer() {
      @Override
      public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        if (org.springframework.util.ClassUtils.isPresent("org.springframework.data.domain.Auditable", getClass().getClassLoader())) {
          jacksonObjectMapperBuilder.mixIn(org.springframework.data.domain.Auditable.class, com.fasterxml.jackson.datatype.spring.data.AuditableSerializer.class);
        }
        if (org.springframework.util.ClassUtils.isPresent("org.springframework.data.domain.Persistable", getClass().getClassLoader())) {
          jacksonObjectMapperBuilder.mixIn(org.springframework.data.domain.Persistable.class, com.fasterxml.jackson.datatype.spring.data.PersistableSerializer.class);
        }
        if (org.springframework.util.ClassUtils.isPresent("org.springframework.security.core.userdetails.UserDetails", getClass().getClassLoader())) {
          jacksonObjectMapperBuilder.mixIn(org.springframework.security.core.userdetails.UserDetails.class, com.fasterxml.jackson.datatype.spring.security.UserDetailsSerializer.class);
        }
//        jacksonObjectMapperBuilder.mixIn(org.springframework.core.io.InputStreamSource.class, com.fasterxml.jackson.datatype.spring.core.InputStreamSourceSerializer.class);
//        jacksonObjectMapperBuilder.mixIn(org.springframework.core.io.WritableResource.class, com.fasterxml.jackson.datatype.spring.core.WritableResourceSerializer.class);
      }
    };
  }
}
