package org.springframework.boot.autoconfigure.aop;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.aop.interceptor.CustomizableTraceInterceptor;
import org.springframework.aop.interceptor.JamonPerformanceMonitorInterceptor;
import org.springframework.aop.interceptor.JamonPerformanceMonitorInterceptorCustom;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@ConditionalOnClass({ EnableAspectJAutoProxy.class, Aspect.class, Advice.class })
@ConditionalOnProperty(prefix = "spring.aop", name = "auto", havingValue = "true", matchIfMissing = true)
@AutoConfigureAfter(AopAutoConfiguration.class)
public class AopAutoConfigurationAfter {
  @Bean
  @ConditionalOnClass(name = "com.jamonapi.Monitor")
  @ConfigurationProperties("spring.aop.interceptor.jamon-performance-monitor")
  @ConditionalOnProperty(prefix = "spring.aop.interceptor.jamon-performance-monitor", name = "enabled", matchIfMissing = true)
  public JamonPerformanceMonitorInterceptorCustom jamonPerformanceMonitorInterceptor() {
    JamonPerformanceMonitorInterceptorCustom jamonPerformanceMonitorInterceptor = new JamonPerformanceMonitorInterceptorCustom();
    return jamonPerformanceMonitorInterceptor;
  }

  @Bean
  @ConfigurationProperties("spring.aop.interceptor.customizable-trace")
  @ConditionalOnProperty(prefix = "spring.aop.interceptor.customizable-trace", name = "enabled", matchIfMissing = true)
  public CustomizableTraceInterceptor customizableTraceInterceptor() {
    StringBuilder enterMessage = new StringBuilder("Entering method '");
    enterMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_METHOD_NAME);
    enterMessage.append('(');
    enterMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_ARGUMENTS);
    enterMessage.append(")' of class [");
    enterMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_TARGET_CLASS_NAME);
    enterMessage.append(']');

    StringBuilder exitMessage = new StringBuilder("Exiting method '");
    exitMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_METHOD_NAME);
    exitMessage.append("' of class [");
    exitMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_TARGET_CLASS_NAME);
    exitMessage.append("] took ");
    exitMessage.append(CustomizableTraceInterceptor.PLACEHOLDER_INVOCATION_TIME);
    exitMessage.append(" ms.");

    CustomizableTraceInterceptor customizableTraceInterceptor = new CustomizableTraceInterceptor();
    customizableTraceInterceptor.setEnterMessage(new String(enterMessage));
    customizableTraceInterceptor.setExitMessage(new String(exitMessage));
    return customizableTraceInterceptor;
  }

  @Bean
  @ConditionalOnClass(name = "com.jamonapi.Monitor")
  @ConditionalOnBean({ JamonPerformanceMonitorInterceptor.class })
  @ConfigurationProperties("spring.aop.advisor.jamon-performance-monitor")
  @ConditionalOnProperty(prefix = "spring.aop.interceptor.jamon-performance-monitor", name = "enabled", matchIfMissing = true)
  public AspectJExpressionPointcutAdvisor jamonPerformanceMonitorAdvisor(JamonPerformanceMonitorInterceptor jamonPerformanceMonitorInterceptor) {
    AspectJExpressionPointcutAdvisor aspectJExpressionPointcutAdvisor = new AspectJExpressionPointcutAdvisor();
    aspectJExpressionPointcutAdvisor.setExpression("@annotation(org.springframework.stereotype.Controller)");
    aspectJExpressionPointcutAdvisor.setAdvice(jamonPerformanceMonitorInterceptor);
    return aspectJExpressionPointcutAdvisor;
  }

  @Bean
  @ConditionalOnBean({ CustomizableTraceInterceptor.class })
  @ConfigurationProperties("spring.aop.advisor.customizable-trace")
  @ConditionalOnProperty(prefix = "spring.aop.interceptor.customizable-trace", name = "enabled", matchIfMissing = true)
  public AspectJExpressionPointcutAdvisor customizableTraceAdvisor(CustomizableTraceInterceptor customizableTraceInterceptor) {
    AspectJExpressionPointcutAdvisor aspectJExpressionPointcutAdvisor = new AspectJExpressionPointcutAdvisor();
    aspectJExpressionPointcutAdvisor.setExpression("execution(@(@org.springframework.web.bind.annotation.RestController *) * *.* (..))");
    // aspectJExpressionPointcutAdvisor.setExpression("execution(@(@org.springframework.stereotype.Controller
    // *) * *.* (..))");
    // aspectJExpressionPointcutAdvisor.setExpression("execution(public *
    // package..*.*(..)) && @annotation(org.springframework.stereotype.Controller)");
    aspectJExpressionPointcutAdvisor.setAdvice(customizableTraceInterceptor);
    return aspectJExpressionPointcutAdvisor;
  }
}
