package org.springframework.boot.autoconfigure;

import java.net.Proxy.Type;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.LinkedCaseInsensitiveMap;

/**
 * @see java.utilTreeMap
 * @see String#CASE_INSENSITIVE_ORDER
 */
@ConfigurationProperties("properties")
public class Properties {
  // private static final long serialVersionUID = -3828334504963147887L;
  private Map<String, Locale> locale = new LinkedCaseInsensitiveMap<Locale>();
  private Map<String, TimeZone> timeZone = new LinkedCaseInsensitiveMap<TimeZone>();
  private Map<String, Date> date = new LinkedCaseInsensitiveMap<Date>();
  private Map<String, Boolean> bool = new LinkedCaseInsensitiveMap<Boolean>();
  private Map<String, Number> num = new LinkedCaseInsensitiveMap<Number>();
  private Map<String, String> key = new LinkedCaseInsensitiveMap<String>();
  private Map<String, URI> uri = new LinkedCaseInsensitiveMap<URI>();
  private Map<String, Resource> resource = new LinkedCaseInsensitiveMap<Resource>();
  private Map<String, List<String>> list = new LinkedCaseInsensitiveMap<List<String>>();
  private Map<String, Map<String, String>> map = new LinkedCaseInsensitiveMap<Map<String, String>>();
  private Map<String, Address> address = new LinkedCaseInsensitiveMap<Address>();

  public Map<String, Map<String, String>> getMap() {
    return map;
  }

  public void setMap(Map<String, Map<String, String>> map) {
    this.map = map;
  }

  public Map<String, List<String>> getList() {
    return list;
  }

  public void setList(Map<String, List<String>> list) {
    this.list = list;
  }

  public Map<String, Boolean> getBool() {
    return bool;
  }

  public void setBool(Map<String, Boolean> bool) {
    this.bool = bool;
  }

  public Map<String, Number> getNum() {
    return num;
  }

  public void setNum(Map<String, Number> num) {
    this.num = num;
  }

  public Map<String, Date> getDate() {
    return date;
  }

  public void setDate(Map<String, Date> date) {
    this.date = date;
  }

  public Map<String, String> getKey() {
    return key;
  }

  public void setKey(Map<String, String> key) {
    this.key = key;
  }

  public Map<String, Locale> getLocale() {
    return locale;
  }

  public void setLocale(Map<String, Locale> locale) {
    this.locale = locale;
  }

  public Map<String, TimeZone> getTimeZone() {
    return timeZone;
  }

  public void setTimeZone(Map<String, TimeZone> timeZone) {
    this.timeZone = timeZone;
  }

  public Map<String, URI> getUri() {
    return uri;
  }

  public void setUri(Map<String, URI> uri) {
    this.uri = uri;
  }

  public Map<String, Resource> getResource() {
    return resource;
  }

  public void setResource(Map<String, Resource> resource) {
    this.resource = resource;
  }

  public Map<String, Address> getAddress() {
    return address;
  }

  public void setAddress(Map<String, Address> address) {
    this.address = address;
  }

  public static class Address {
    private String scheme;
    private String host;
    private int port;
    private URI uri;
    private Type type;
    private String username;
    private String password;
    private String key;
    private int connectTimeout;
    private int readTimeout;
    private String description;
    private String icon;
    private String domain;
    private String title;
    private String name;
    private Properties properties;

    public String getScheme() {
      return scheme;
    }

    public void setScheme(String scheme) {
      this.scheme = scheme;
    }

    public String getHost() {
      return host;
    }

    public void setHost(String host) {
      this.host = host;
    }

    public int getPort() {
      return port;
    }

    public void setPort(int port) {
      this.port = port;
    }

    public URI getUri() {
      return uri;
    }

    public void setUri(URI uri) {
      this.uri = uri;
    }

    public Type getType() {
      return type;
    }

    public void setType(Type type) {
      this.type = type;
    }

    public String getUsername() {
      return username;
    }

    public void setUsername(String username) {
      this.username = username;
    }

    public String getPassword() {
      return password;
    }

    public void setPassword(String password) {
      this.password = password;
    }

    public String getKey() {
      return key;
    }

    public void setKey(String key) {
      this.key = key;
    }

    public int getConnectTimeout() {
      return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
      this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
      return readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
      this.readTimeout = readTimeout;
    }

    public String getDescription() {
      return description;
    }

    public void setDescription(String description) {
      this.description = description;
    }

    public String getIcon() {
      return icon;
    }

    public void setIcon(String icon) {
      this.icon = icon;
    }

    public String getDomain() {
      return domain;
    }

    public void setDomain(String domain) {
      this.domain = domain;
    }

    public String getTitle() {
      return title;
    }

    public void setTitle(String title) {
      this.title = title;
    }

    public String getName() {
      return name;
    }

    public void setName(String name) {
      this.name = name;
    }

    public Properties getProperties() {
      return properties;
    }

    public void setProperties(Properties properties) {
      this.properties = properties;
    }
  }
}
