package org.springframework.boot.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.support.StringToBooleanConverterCustom;
import org.springframework.core.convert.support.StringToDateConverter;

/**
 * @see org.springframework.context.ResourceLoaderAware
 */
@Configuration
@ConditionalOnClass(Object.class)
public class AutoConfiguration {
  /**
   * <code>
  &#64;Bean
  public ConversionServiceFactoryBean conversionService(ApplicationContext applicationContext) {
    ConversionServiceFactoryBean conversionServiceFactoryBean = new ConversionServiceFactoryBean() {
      &#64;Override
      protected GenericConversionService createConversionService() {
        GenericConversionService genericConversionService = super.createConversionService();
        genericConversionService.addConverter(Object.class, byte[].class, new SerializingConverter());
        genericConversionService.addConverter(byte[].class, Object.class, new DeserializingConverter(applicationContext.getClassLoader()));
        genericConversionService.addConverter(new StringToDateConverter());
        return genericConversionService;
      }
    };
    return conversionServiceFactoryBean;
  }
   * </code>
   * @see org.springframework.core.convert.support.DefaultConversionService
   * @see org.springframework.context.ConfigurableApplicationContext#CONVERSION_SERVICE_BEAN_NAME
   */
  @Bean
  @ConfigurationPropertiesBinding
  public StringToDateConverter stringToDateConverter() {
    return new StringToDateConverter();
  }

  @Bean
  public Properties properties() {
    return new Properties();
  }

  @Bean
  @ConfigurationPropertiesBinding
  public StringToBooleanConverterCustom stringToBooleanConverter() {
    return new StringToBooleanConverterCustom();
  }
}
