package org.springframework.boot.actuate.info;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

import org.springframework.boot.actuate.info.Info.Builder;
import org.springframework.util.ResourceUtils;

/**
 * @see org.springframework.core.io.support.ResourcePatternUtils#getResourcePatternResolver(org.springframework.core.io.ResourceLoader)
 * @see org.springframework.core.io.DefaultResourceLoader
 */
public class ResourceInfoContributor implements org.springframework.boot.actuate.info.InfoContributor {
  @Override
  public void contribute(Builder builder) {
    Map<String, File> resource = new LinkedHashMap<String, File>();
    try {
      resource.put("file", ResourceUtils.getFile("file:").getCanonicalFile());
      resource.put("classpath", ResourceUtils.getFile("classpath:").getCanonicalFile());
    }
    catch (IOException e) {
      // ignore
    }
    builder.withDetail("resource", resource);
  }
}
