package org.springframework.boot.actuate.info;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import org.springframework.boot.actuate.info.Info.Builder;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ClassUtils;

public class LocaleInfoContributor implements org.springframework.boot.actuate.info.InfoContributor {
  private final boolean localeContext = ClassUtils.isPresent("org.springframework.context.i18n.LocaleContextHolder", getClass().getClassLoader());

  @Override
  public void contribute(Builder builder) {
    if (this.localeContext) {
      Map<String, Locale> locale = new LinkedHashMap<String, Locale>();
      locale.put("local", Locale.getDefault());
      locale.put("remote", LocaleContextHolder.getLocale());
      builder.withDetail("locale", locale);

      Map<String, TimeZone> timeZone = new LinkedHashMap<String, TimeZone>();
      timeZone.put("local", TimeZone.getDefault());
      timeZone.put("remote", LocaleContextHolder.getTimeZone());
      builder.withDetail("timeZone", timeZone);
    }
  }
}
