package org.springframework.boot.actuate.health;

import java.io.File;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(prefix = "management.health.mount")
public class MountHealthIndicatorProperties {
  private static final long EXECUTE = 1 << 0;
  private static final long WRITE = 1 << 1;
  private static final long READ = 1 << 2;

  private static final long FILE = 1 << 0;
  private static final long DIRECTORY = 1 << 1;
  private static final long ABSOLUTE = 1 << 2;
  private static final long HIDDEN = 1 << 3;

  private Resource resource = new FileSystemResource(new File("."));
  private long access = 7l;
  private long type = 2l;

  public MountHealthIndicatorProperties() {
  }

  public Resource getResource() {
    return resource;
  }

  public void setResource(Resource resource) {
    this.resource = resource;
  }

  public boolean isRead() {
    return (this.access & READ) == READ;
  }

  public void setRead(boolean read) {
    this.access = read ? this.access | READ : this.access & ~READ;
  }

  public boolean isExecute() {
    return (this.access & EXECUTE) == EXECUTE;
  }

  public void setExecute(boolean execute) {
    this.access = execute ? this.access | EXECUTE : this.access & ~EXECUTE;
  }

  public boolean isWrite() {
    return (this.access & WRITE) == WRITE;
  }

  public void setWrite(boolean write) {
    this.access = write ? this.access | WRITE : this.access & ~WRITE;
  }

  public long getAccess() {
    return access;
  }

  public void setAccess(long access) {
    this.access = access;
  }

  public boolean isFile() {
    return (this.type & FILE) == FILE;
  }

  public void setFile(boolean file) {
    this.type = file ? this.type | FILE : this.type & ~FILE;
  }

  public boolean isDirectory() {
    return (this.type & DIRECTORY) == DIRECTORY;
  }

  public void setDirectory(boolean directory) {
    this.type = directory ? this.type | DIRECTORY : this.type & ~DIRECTORY;
  }

  public boolean isAbsolute() {
    return (this.type & ABSOLUTE) == ABSOLUTE;
  }

  public void setAbsolute(boolean absolute) {
    this.type = absolute ? this.type | ABSOLUTE : this.type & ~ABSOLUTE;
  }

  public boolean isHidden() {
    return (this.type & HIDDEN) == HIDDEN;
  }

  public void setHidden(boolean hidden) {
    this.type = hidden ? this.type | HIDDEN : this.type & ~HIDDEN;
  }

  public long getType() {
    return type;
  }

  public void setType(long type) {
    this.type = type;
  }
}
