package org.springframework.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.MountHealthIndicator;
import org.springframework.boot.actuate.health.MountHealthIndicatorProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(org.springframework.boot.actuate.health.HealthIndicator.class)
@AutoConfigureBefore(EndpointAutoConfiguration.class)
@AutoConfigureAfter(HealthIndicatorAutoConfiguration.class)
public class HealthIndicatorAutoConfigurationAfter {
  @Configuration
  @ConditionalOnEnabledHealthIndicator("mount")
  public static class MountHealthIndicatorConfiguration {
    @Bean
    @ConditionalOnMissingBean(name = "mountHealthIndicator")
    public HealthIndicator mountHealthIndicator(MountHealthIndicatorProperties mountHealthIndicatorProperties) {
      return new MountHealthIndicator(mountHealthIndicatorProperties);
    }

    @Bean
    public MountHealthIndicatorProperties mountHealthIndicatorProperties() {
      return new MountHealthIndicatorProperties();
    }
  }
}
