/*
 * Decompiled with CFR 0.152.
 */
package io.kvision.remote;

import io.kvision.remote.KVServiceManager;
import io.kvision.remote.KVWebSocketHandler;
import io.kvision.remote.KVWebSocketSession;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\nH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kvision/remote/KVWebSocketConfig;", "", "services", "", "Lio/kvision/remote/KVServiceManager;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Ljava/util/List;Lorg/springframework/context/ApplicationContext;)V", "threadLocalWebSocketSession", "Ljava/lang/ThreadLocal;", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "handlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "handlerMapping", "Lorg/springframework/web/reactive/HandlerMapping;", "webSocketSession", "kvision-server-spring-boot"})
public class KVWebSocketConfig {
    @NotNull
    private final List<KVServiceManager<?>> services;
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ThreadLocal<WebSocketSession> threadLocalWebSocketSession;

    public KVWebSocketConfig(@NotNull List<? extends KVServiceManager<?>> services, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.services = services;
        this.applicationContext = applicationContext;
        this.threadLocalWebSocketSession = new ThreadLocal();
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public WebSocketSession webSocketSession() {
        WebSocketSession webSocketSession = this.threadLocalWebSocketSession.get();
        if (webSocketSession == null) {
            webSocketSession = new KVWebSocketSession();
        }
        return webSocketSession;
    }

    @Bean
    @NotNull
    public HandlerMapping handlerMapping() {
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"/kvws/*", (Object)new KVWebSocketHandler(this.services, this.threadLocalWebSocketSession, this.applicationContext)));
        int order = -1;
        return (HandlerMapping)new SimpleUrlHandlerMapping(map, order);
    }

    @Bean
    @NotNull
    public WebSocketHandlerAdapter handlerAdapter() {
        return new WebSocketHandlerAdapter();
    }
}

