(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kvision-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kvision-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-imask-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kvision-kvision-imask-js-legacy'.");
    }
    if (typeof this['kvision-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-imask-js-legacy'. Its dependency 'kvision-js-legacy' was not found. Please, check whether 'kvision-js-legacy' is loaded prior to 'kvision-kvision-imask-js-legacy'.");
    }
    root['kvision-kvision-imask-js-legacy'] = factory(typeof this['kvision-kvision-imask-js-legacy'] === 'undefined' ? {} : this['kvision-kvision-imask-js-legacy'], kotlin, this['kvision-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kvision_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var text = $module$kvision_js_legacy.io.kvision.form.text;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ModuleInitializer = $module$kvision_js_legacy.io.kvision.ModuleInitializer;
  var Unit = Kotlin.kotlin.Unit;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Mask = $module$kvision_js_legacy.io.kvision.form.text.Mask;
  var MaskFactory = $module$kvision_js_legacy.io.kvision.form.text.MaskFactory;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var toBoxedChar = Kotlin.toBoxedChar;
  var unboxChar = Kotlin.unboxChar;
  var equals = Kotlin.equals;
  var MaskOptions = $module$kvision_js_legacy.io.kvision.form.text.MaskOptions;
  var Object_init = Object;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  MaskOverwrite.prototype = Object.create(Enum.prototype);
  MaskOverwrite.prototype.constructor = MaskOverwrite;
  MaskAutofix.prototype = Object.create(Enum.prototype);
  MaskAutofix.prototype.constructor = MaskAutofix;
  function ImaskModule() {
    ImaskModule_instance = this;
    this.imask_8be2vx$ = require('imask').default;
  }
  ImaskModule.prototype.initialize = function () {
    text.MaskManager.factory = new ImaskFactory(this.imask_8be2vx$);
  };
  ImaskModule.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ImaskModule',
    interfaces: [ModuleInitializer]
  };
  var ImaskModule_instance = null;
  function ImaskModule_getInstance() {
    if (ImaskModule_instance === null) {
      new ImaskModule();
    }
    return ImaskModule_instance;
  }
  function Imask(imask) {
    this.imask_0 = imask;
  }
  Imask.prototype.destroy = function () {
    this.imask_0.destroy();
  };
  Imask.prototype.getValue = function () {
    return this.imask_0.unmaskedValue;
  };
  function Imask$onChange$lambda(closure$callback, this$Imask) {
    return function () {
      closure$callback(this$Imask.getValue());
      return Unit;
    };
  }
  Imask.prototype.onChange_rnyx3q$ = function (callback) {
    this.imask_0.on('accept', Imask$onChange$lambda(callback, this));
  };
  Imask.prototype.refresh = function () {
    this.imask_0.updateValue();
    this.imask_0.updateControl();
  };
  Imask.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Imask',
    interfaces: [Mask]
  };
  function ImaskFactory(imask) {
    this.imask_0 = imask;
  }
  ImaskFactory.prototype.createMask_wd8ck0$ = function (element, options) {
    return new Imask(this.imask_0.call(this, element, toJs_3(options, this.imask_0)));
  };
  ImaskFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImaskFactory',
    interfaces: [MaskFactory]
  };
  function MaskOverwrite(name, ordinal, overwrite) {
    Enum.call(this);
    this.overwrite_8be2vx$ = overwrite;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function MaskOverwrite_initFields() {
    MaskOverwrite_initFields = function () {
    };
    MaskOverwrite$TRUE_instance = new MaskOverwrite('TRUE', 0, 'true');
    MaskOverwrite$FALSE_instance = new MaskOverwrite('FALSE', 1, 'false');
    MaskOverwrite$SHIFT_instance = new MaskOverwrite('SHIFT', 2, 'shift');
  }
  var MaskOverwrite$TRUE_instance;
  function MaskOverwrite$TRUE_getInstance() {
    MaskOverwrite_initFields();
    return MaskOverwrite$TRUE_instance;
  }
  var MaskOverwrite$FALSE_instance;
  function MaskOverwrite$FALSE_getInstance() {
    MaskOverwrite_initFields();
    return MaskOverwrite$FALSE_instance;
  }
  var MaskOverwrite$SHIFT_instance;
  function MaskOverwrite$SHIFT_getInstance() {
    MaskOverwrite_initFields();
    return MaskOverwrite$SHIFT_instance;
  }
  MaskOverwrite.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MaskOverwrite',
    interfaces: [Enum]
  };
  function MaskOverwrite$values() {
    return [MaskOverwrite$TRUE_getInstance(), MaskOverwrite$FALSE_getInstance(), MaskOverwrite$SHIFT_getInstance()];
  }
  MaskOverwrite.values = MaskOverwrite$values;
  function MaskOverwrite$valueOf(name) {
    switch (name) {
      case 'TRUE':
        return MaskOverwrite$TRUE_getInstance();
      case 'FALSE':
        return MaskOverwrite$FALSE_getInstance();
      case 'SHIFT':
        return MaskOverwrite$SHIFT_getInstance();
      default:
        throwISE('No enum constant io.kvision.form.text.MaskOverwrite.' + name);
    }
  }
  MaskOverwrite.valueOf_61zpoe$ = MaskOverwrite$valueOf;
  function MaskAutofix(name, ordinal, autofix) {
    Enum.call(this);
    this.autofix_8be2vx$ = autofix;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function MaskAutofix_initFields() {
    MaskAutofix_initFields = function () {
    };
    MaskAutofix$TRUE_instance = new MaskAutofix('TRUE', 0, 'true');
    MaskAutofix$FALSE_instance = new MaskAutofix('FALSE', 1, 'false');
    MaskAutofix$PAD_instance = new MaskAutofix('PAD', 2, 'pad');
  }
  var MaskAutofix$TRUE_instance;
  function MaskAutofix$TRUE_getInstance() {
    MaskAutofix_initFields();
    return MaskAutofix$TRUE_instance;
  }
  var MaskAutofix$FALSE_instance;
  function MaskAutofix$FALSE_getInstance() {
    MaskAutofix_initFields();
    return MaskAutofix$FALSE_instance;
  }
  var MaskAutofix$PAD_instance;
  function MaskAutofix$PAD_getInstance() {
    MaskAutofix_initFields();
    return MaskAutofix$PAD_instance;
  }
  MaskAutofix.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MaskAutofix',
    interfaces: [Enum]
  };
  function MaskAutofix$values() {
    return [MaskAutofix$TRUE_getInstance(), MaskAutofix$FALSE_getInstance(), MaskAutofix$PAD_getInstance()];
  }
  MaskAutofix.values = MaskAutofix$values;
  function MaskAutofix$valueOf(name) {
    switch (name) {
      case 'TRUE':
        return MaskAutofix$TRUE_getInstance();
      case 'FALSE':
        return MaskAutofix$FALSE_getInstance();
      case 'PAD':
        return MaskAutofix$PAD_getInstance();
      default:
        throwISE('No enum constant io.kvision.form.text.MaskAutofix.' + name);
    }
  }
  MaskAutofix.valueOf_61zpoe$ = MaskAutofix$valueOf;
  function PatternMask(pattern, lazy, eager, placeholderChar, definitions, blocks) {
    if (lazy === void 0)
      lazy = null;
    if (eager === void 0)
      eager = null;
    if (placeholderChar === void 0)
      placeholderChar = null;
    if (definitions === void 0)
      definitions = null;
    if (blocks === void 0)
      blocks = null;
    this.pattern = pattern;
    this.lazy = lazy;
    this.eager = eager;
    this.placeholderChar = toBoxedChar(placeholderChar);
    this.definitions = definitions;
    this.blocks = blocks;
  }
  PatternMask.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PatternMask',
    interfaces: []
  };
  PatternMask.prototype.component1 = function () {
    return this.pattern;
  };
  PatternMask.prototype.component2 = function () {
    return this.lazy;
  };
  PatternMask.prototype.component3 = function () {
    return this.eager;
  };
  PatternMask.prototype.component4 = function () {
    return this.placeholderChar;
  };
  PatternMask.prototype.component5 = function () {
    return this.definitions;
  };
  PatternMask.prototype.component6 = function () {
    return this.blocks;
  };
  PatternMask.prototype.copy_muny36$ = function (pattern, lazy, eager, placeholderChar, definitions, blocks) {
    return new PatternMask(pattern === void 0 ? this.pattern : pattern, lazy === void 0 ? this.lazy : lazy, eager === void 0 ? this.eager : eager, placeholderChar === void 0 ? this.placeholderChar : placeholderChar, definitions === void 0 ? this.definitions : definitions, blocks === void 0 ? this.blocks : blocks);
  };
  PatternMask.prototype.toString = function () {
    return 'PatternMask(pattern=' + Kotlin.toString(this.pattern) + (', lazy=' + Kotlin.toString(this.lazy)) + (', eager=' + Kotlin.toString(this.eager)) + (', placeholderChar=' + Kotlin.toString(this.placeholderChar)) + (', definitions=' + Kotlin.toString(this.definitions)) + (', blocks=' + Kotlin.toString(this.blocks)) + ')';
  };
  PatternMask.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.pattern) | 0;
    result = result * 31 + Kotlin.hashCode(this.lazy) | 0;
    result = result * 31 + Kotlin.hashCode(this.eager) | 0;
    result = result * 31 + Kotlin.hashCode(this.placeholderChar) | 0;
    result = result * 31 + Kotlin.hashCode(this.definitions) | 0;
    result = result * 31 + Kotlin.hashCode(this.blocks) | 0;
    return result;
  };
  PatternMask.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.pattern, other.pattern) && Kotlin.equals(this.lazy, other.lazy) && Kotlin.equals(this.eager, other.eager) && Kotlin.equals(this.placeholderChar, other.placeholderChar) && Kotlin.equals(this.definitions, other.definitions) && Kotlin.equals(this.blocks, other.blocks)))));
  };
  function toJs($receiver, imask) {
    var $receiver_0 = new Object_init();
    $receiver_0.mask = $receiver.pattern;
    if ($receiver.lazy != null)
      $receiver_0.lazy = $receiver.lazy;
    if ($receiver.eager != null)
      $receiver_0.eager = $receiver.eager;
    if (unboxChar($receiver.placeholderChar) != null)
      $receiver_0.placeholderChar = String.fromCharCode(unboxChar($receiver.placeholderChar));
    if ($receiver.definitions != null)
      $receiver_0.definitions = $receiver.definitions;
    if ($receiver.blocks != null) {
      var $receiver_1 = new Object_init();
      var tmp$;
      tmp$ = $receiver.blocks.entries.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var def = element.key;
        var options = element.value;
        $receiver_1[def] = toJs_3(options, imask);
      }
      $receiver_0.blocks = $receiver_1;
    }
    return $receiver_0;
  }
  function RangeMask(from, to, maxLength, autofix, lazy, eager, placeholderChar) {
    if (maxLength === void 0)
      maxLength = null;
    if (autofix === void 0)
      autofix = null;
    if (lazy === void 0)
      lazy = null;
    if (eager === void 0)
      eager = null;
    if (placeholderChar === void 0)
      placeholderChar = null;
    this.from = from;
    this.to = to;
    this.maxLength = maxLength;
    this.autofix = autofix;
    this.lazy = lazy;
    this.eager = eager;
    this.placeholderChar = toBoxedChar(placeholderChar);
  }
  RangeMask.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RangeMask',
    interfaces: []
  };
  RangeMask.prototype.component1 = function () {
    return this.from;
  };
  RangeMask.prototype.component2 = function () {
    return this.to;
  };
  RangeMask.prototype.component3 = function () {
    return this.maxLength;
  };
  RangeMask.prototype.component4 = function () {
    return this.autofix;
  };
  RangeMask.prototype.component5 = function () {
    return this.lazy;
  };
  RangeMask.prototype.component6 = function () {
    return this.eager;
  };
  RangeMask.prototype.component7 = function () {
    return this.placeholderChar;
  };
  RangeMask.prototype.copy_g0j77c$ = function (from, to, maxLength, autofix, lazy, eager, placeholderChar) {
    return new RangeMask(from === void 0 ? this.from : from, to === void 0 ? this.to : to, maxLength === void 0 ? this.maxLength : maxLength, autofix === void 0 ? this.autofix : autofix, lazy === void 0 ? this.lazy : lazy, eager === void 0 ? this.eager : eager, placeholderChar === void 0 ? this.placeholderChar : placeholderChar);
  };
  RangeMask.prototype.toString = function () {
    return 'RangeMask(from=' + Kotlin.toString(this.from) + (', to=' + Kotlin.toString(this.to)) + (', maxLength=' + Kotlin.toString(this.maxLength)) + (', autofix=' + Kotlin.toString(this.autofix)) + (', lazy=' + Kotlin.toString(this.lazy)) + (', eager=' + Kotlin.toString(this.eager)) + (', placeholderChar=' + Kotlin.toString(this.placeholderChar)) + ')';
  };
  RangeMask.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.from) | 0;
    result = result * 31 + Kotlin.hashCode(this.to) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxLength) | 0;
    result = result * 31 + Kotlin.hashCode(this.autofix) | 0;
    result = result * 31 + Kotlin.hashCode(this.lazy) | 0;
    result = result * 31 + Kotlin.hashCode(this.eager) | 0;
    result = result * 31 + Kotlin.hashCode(this.placeholderChar) | 0;
    return result;
  };
  RangeMask.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.from, other.from) && Kotlin.equals(this.to, other.to) && Kotlin.equals(this.maxLength, other.maxLength) && Kotlin.equals(this.autofix, other.autofix) && Kotlin.equals(this.lazy, other.lazy) && Kotlin.equals(this.eager, other.eager) && Kotlin.equals(this.placeholderChar, other.placeholderChar)))));
  };
  function toJs_0($receiver, imask) {
    var tmp$, tmp$_0;
    tmp$ = $receiver.autofix;
    if (equals(tmp$, MaskAutofix$TRUE_getInstance()))
      tmp$_0 = true;
    else if (equals(tmp$, MaskAutofix$PAD_getInstance()))
      tmp$_0 = MaskAutofix$PAD_getInstance().autofix_8be2vx$;
    else
      tmp$_0 = undefined;
    var autofixDynamic = tmp$_0;
    var $receiver_0 = new Object_init();
    $receiver_0.mask = imask.MaskedRange;
    $receiver_0.from = $receiver.from;
    $receiver_0.to = $receiver.to;
    if ($receiver.maxLength != null)
      $receiver_0.maxLength = $receiver.maxLength;
    if ($receiver.autofix != null)
      $receiver_0.autofix = autofixDynamic;
    if ($receiver.lazy != null)
      $receiver_0.lazy = $receiver.lazy;
    if ($receiver.eager != null)
      $receiver_0.eager = $receiver.eager;
    if (unboxChar($receiver.placeholderChar) != null)
      $receiver_0.placeholderChar = String.fromCharCode(unboxChar($receiver.placeholderChar));
    return $receiver_0;
  }
  function EnumMask(enum_0, lazy, eager, placeholderChar) {
    if (lazy === void 0)
      lazy = null;
    if (eager === void 0)
      eager = null;
    if (placeholderChar === void 0)
      placeholderChar = null;
    this.enum = enum_0;
    this.lazy = lazy;
    this.eager = eager;
    this.placeholderChar = toBoxedChar(placeholderChar);
  }
  EnumMask.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumMask',
    interfaces: []
  };
  EnumMask.prototype.component1 = function () {
    return this.enum;
  };
  EnumMask.prototype.component2 = function () {
    return this.lazy;
  };
  EnumMask.prototype.component3 = function () {
    return this.eager;
  };
  EnumMask.prototype.component4 = function () {
    return this.placeholderChar;
  };
  EnumMask.prototype.copy_g6bla3$ = function (enum_0, lazy, eager, placeholderChar) {
    return new EnumMask(enum_0 === void 0 ? this.enum : enum_0, lazy === void 0 ? this.lazy : lazy, eager === void 0 ? this.eager : eager, placeholderChar === void 0 ? this.placeholderChar : placeholderChar);
  };
  EnumMask.prototype.toString = function () {
    return 'EnumMask(enum=' + Kotlin.toString(this.enum) + (', lazy=' + Kotlin.toString(this.lazy)) + (', eager=' + Kotlin.toString(this.eager)) + (', placeholderChar=' + Kotlin.toString(this.placeholderChar)) + ')';
  };
  EnumMask.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.enum) | 0;
    result = result * 31 + Kotlin.hashCode(this.lazy) | 0;
    result = result * 31 + Kotlin.hashCode(this.eager) | 0;
    result = result * 31 + Kotlin.hashCode(this.placeholderChar) | 0;
    return result;
  };
  EnumMask.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.enum, other.enum) && Kotlin.equals(this.lazy, other.lazy) && Kotlin.equals(this.eager, other.eager) && Kotlin.equals(this.placeholderChar, other.placeholderChar)))));
  };
  function toJs_1($receiver, imask) {
    var $receiver_0 = new Object_init();
    $receiver_0.mask = imask.MaskedEnum;
    $receiver_0.enum = copyToArray($receiver.enum);
    if ($receiver.lazy != null)
      $receiver_0.lazy = $receiver.lazy;
    if ($receiver.eager != null)
      $receiver_0.eager = $receiver.eager;
    if (unboxChar($receiver.placeholderChar) != null)
      $receiver_0.placeholderChar = String.fromCharCode(unboxChar($receiver.placeholderChar));
    return $receiver_0;
  }
  function NumberMask(scale, signed, thousandsSeparator, padFractionalZeros, normalizeZeros, radix, mapToRadix, min, max) {
    if (scale === void 0)
      scale = null;
    if (signed === void 0)
      signed = null;
    if (thousandsSeparator === void 0)
      thousandsSeparator = null;
    if (padFractionalZeros === void 0)
      padFractionalZeros = null;
    if (normalizeZeros === void 0)
      normalizeZeros = null;
    if (radix === void 0)
      radix = null;
    if (mapToRadix === void 0)
      mapToRadix = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    this.scale = scale;
    this.signed = signed;
    this.thousandsSeparator = toBoxedChar(thousandsSeparator);
    this.padFractionalZeros = padFractionalZeros;
    this.normalizeZeros = normalizeZeros;
    this.radix = toBoxedChar(radix);
    this.mapToRadix = mapToRadix;
    this.min = min;
    this.max = max;
  }
  NumberMask.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NumberMask',
    interfaces: []
  };
  NumberMask.prototype.component1 = function () {
    return this.scale;
  };
  NumberMask.prototype.component2 = function () {
    return this.signed;
  };
  NumberMask.prototype.component3 = function () {
    return this.thousandsSeparator;
  };
  NumberMask.prototype.component4 = function () {
    return this.padFractionalZeros;
  };
  NumberMask.prototype.component5 = function () {
    return this.normalizeZeros;
  };
  NumberMask.prototype.component6 = function () {
    return this.radix;
  };
  NumberMask.prototype.component7 = function () {
    return this.mapToRadix;
  };
  NumberMask.prototype.component8 = function () {
    return this.min;
  };
  NumberMask.prototype.component9 = function () {
    return this.max;
  };
  NumberMask.prototype.copy_pdqrq0$ = function (scale, signed, thousandsSeparator, padFractionalZeros, normalizeZeros, radix, mapToRadix, min, max) {
    return new NumberMask(scale === void 0 ? this.scale : scale, signed === void 0 ? this.signed : signed, thousandsSeparator === void 0 ? this.thousandsSeparator : thousandsSeparator, padFractionalZeros === void 0 ? this.padFractionalZeros : padFractionalZeros, normalizeZeros === void 0 ? this.normalizeZeros : normalizeZeros, radix === void 0 ? this.radix : radix, mapToRadix === void 0 ? this.mapToRadix : mapToRadix, min === void 0 ? this.min : min, max === void 0 ? this.max : max);
  };
  NumberMask.prototype.toString = function () {
    return 'NumberMask(scale=' + Kotlin.toString(this.scale) + (', signed=' + Kotlin.toString(this.signed)) + (', thousandsSeparator=' + Kotlin.toString(this.thousandsSeparator)) + (', padFractionalZeros=' + Kotlin.toString(this.padFractionalZeros)) + (', normalizeZeros=' + Kotlin.toString(this.normalizeZeros)) + (', radix=' + Kotlin.toString(this.radix)) + (', mapToRadix=' + Kotlin.toString(this.mapToRadix)) + (', min=' + Kotlin.toString(this.min)) + (', max=' + Kotlin.toString(this.max)) + ')';
  };
  NumberMask.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.scale) | 0;
    result = result * 31 + Kotlin.hashCode(this.signed) | 0;
    result = result * 31 + Kotlin.hashCode(this.thousandsSeparator) | 0;
    result = result * 31 + Kotlin.hashCode(this.padFractionalZeros) | 0;
    result = result * 31 + Kotlin.hashCode(this.normalizeZeros) | 0;
    result = result * 31 + Kotlin.hashCode(this.radix) | 0;
    result = result * 31 + Kotlin.hashCode(this.mapToRadix) | 0;
    result = result * 31 + Kotlin.hashCode(this.min) | 0;
    result = result * 31 + Kotlin.hashCode(this.max) | 0;
    return result;
  };
  NumberMask.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.scale, other.scale) && Kotlin.equals(this.signed, other.signed) && Kotlin.equals(this.thousandsSeparator, other.thousandsSeparator) && Kotlin.equals(this.padFractionalZeros, other.padFractionalZeros) && Kotlin.equals(this.normalizeZeros, other.normalizeZeros) && Kotlin.equals(this.radix, other.radix) && Kotlin.equals(this.mapToRadix, other.mapToRadix) && Kotlin.equals(this.min, other.min) && Kotlin.equals(this.max, other.max)))));
  };
  function toJs_2($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.mask = Number;
    if ($receiver.scale != null)
      $receiver_0.scale = $receiver.scale;
    if ($receiver.signed != null)
      $receiver_0.signed = $receiver.signed;
    if (unboxChar($receiver.thousandsSeparator) != null)
      $receiver_0.thousandsSeparator = String.fromCharCode(unboxChar($receiver.thousandsSeparator));
    if ($receiver.padFractionalZeros != null)
      $receiver_0.padFractionalZeros = $receiver.padFractionalZeros;
    if ($receiver.normalizeZeros != null)
      $receiver_0.normalizeZeros = $receiver.normalizeZeros;
    if (unboxChar($receiver.radix) != null)
      $receiver_0.radix = String.fromCharCode(unboxChar($receiver.radix));
    if ($receiver.mapToRadix != null) {
      var $receiver_1 = $receiver.mapToRadix;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(String.fromCharCode(unboxChar(item)));
      }
      $receiver_0.mapToRadix = copyToArray(destination);
    }
    if ($receiver.min != null)
      $receiver_0.min = $receiver.min;
    if ($receiver.max != null)
      $receiver_0.max = $receiver.max;
    return $receiver_0;
  }
  function ImaskOptions(pattern, range, enum_0, number, regExp, function_0, list, overwrite) {
    if (pattern === void 0)
      pattern = null;
    if (range === void 0)
      range = null;
    if (enum_0 === void 0)
      enum_0 = null;
    if (number === void 0)
      number = null;
    if (regExp === void 0)
      regExp = null;
    if (function_0 === void 0)
      function_0 = null;
    if (list === void 0)
      list = null;
    if (overwrite === void 0)
      overwrite = null;
    this.pattern = pattern;
    this.range = range;
    this.enum = enum_0;
    this.number = number;
    this.regExp = regExp;
    this.function = function_0;
    this.list = list;
    this.overwrite = overwrite;
  }
  ImaskOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImaskOptions',
    interfaces: [MaskOptions]
  };
  ImaskOptions.prototype.component1 = function () {
    return this.pattern;
  };
  ImaskOptions.prototype.component2 = function () {
    return this.range;
  };
  ImaskOptions.prototype.component3 = function () {
    return this.enum;
  };
  ImaskOptions.prototype.component4 = function () {
    return this.number;
  };
  ImaskOptions.prototype.component5 = function () {
    return this.regExp;
  };
  ImaskOptions.prototype.component6 = function () {
    return this.function;
  };
  ImaskOptions.prototype.component7 = function () {
    return this.list;
  };
  ImaskOptions.prototype.component8 = function () {
    return this.overwrite;
  };
  ImaskOptions.prototype.copy_5ugv80$ = function (pattern, range, enum_0, number, regExp, function_0, list, overwrite) {
    return new ImaskOptions(pattern === void 0 ? this.pattern : pattern, range === void 0 ? this.range : range, enum_0 === void 0 ? this.enum : enum_0, number === void 0 ? this.number : number, regExp === void 0 ? this.regExp : regExp, function_0 === void 0 ? this.function : function_0, list === void 0 ? this.list : list, overwrite === void 0 ? this.overwrite : overwrite);
  };
  ImaskOptions.prototype.toString = function () {
    return 'ImaskOptions(pattern=' + Kotlin.toString(this.pattern) + (', range=' + Kotlin.toString(this.range)) + (', enum=' + Kotlin.toString(this.enum)) + (', number=' + Kotlin.toString(this.number)) + (', regExp=' + Kotlin.toString(this.regExp)) + (', function=' + Kotlin.toString(this.function)) + (', list=' + Kotlin.toString(this.list)) + (', overwrite=' + Kotlin.toString(this.overwrite)) + ')';
  };
  ImaskOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.pattern) | 0;
    result = result * 31 + Kotlin.hashCode(this.range) | 0;
    result = result * 31 + Kotlin.hashCode(this.enum) | 0;
    result = result * 31 + Kotlin.hashCode(this.number) | 0;
    result = result * 31 + Kotlin.hashCode(this.regExp) | 0;
    result = result * 31 + Kotlin.hashCode(this.function) | 0;
    result = result * 31 + Kotlin.hashCode(this.list) | 0;
    result = result * 31 + Kotlin.hashCode(this.overwrite) | 0;
    return result;
  };
  ImaskOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.pattern, other.pattern) && Kotlin.equals(this.range, other.range) && Kotlin.equals(this.enum, other.enum) && Kotlin.equals(this.number, other.number) && Kotlin.equals(this.regExp, other.regExp) && Kotlin.equals(this.function, other.function) && Kotlin.equals(this.list, other.list) && Kotlin.equals(this.overwrite, other.overwrite)))));
  };
  function toJs_3($receiver, imask) {
    var tmp$, tmp$_0;
    tmp$ = $receiver.overwrite;
    if (equals(tmp$, MaskOverwrite$TRUE_getInstance()))
      tmp$_0 = true;
    else if (equals(tmp$, MaskOverwrite$SHIFT_getInstance()))
      tmp$_0 = MaskOverwrite$SHIFT_getInstance().overwrite_8be2vx$;
    else
      tmp$_0 = undefined;
    var overwriteDynamic = tmp$_0;
    var $receiver_0 = new Object_init();
    if ($receiver.pattern != null) {
      var patternOptions = toJs($receiver.pattern, imask);
      Object.assign($receiver_0, patternOptions);
    } else if ($receiver.range != null) {
      var rangeOptions = toJs_0($receiver.range, imask);
      Object.assign($receiver_0, rangeOptions);
    } else if ($receiver.enum != null) {
      var enumOptions = toJs_1($receiver.enum, imask);
      Object.assign($receiver_0, enumOptions);
    } else if ($receiver.number != null) {
      var numberOptions = toJs_2($receiver.number);
      Object.assign($receiver_0, numberOptions);
    } else if ($receiver.regExp != null) {
      $receiver_0.mask = $receiver.regExp;
    } else if ($receiver.function != null) {
      $receiver_0.mask = $receiver.function;
    } else if ($receiver.list != null) {
      var $receiver_1 = $receiver.list;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$_1;
      tmp$_1 = $receiver_1.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        destination.add_11rb$(toJs_3(item, imask));
      }
      $receiver_0.mask = copyToArray(destination);
    }
    if ($receiver.overwrite != null)
      $receiver_0.overwrite = overwriteDynamic;
    return $receiver_0;
  }
  var package$io = _.io || (_.io = {});
  var package$kvision = package$io.kvision || (package$io.kvision = {});
  Object.defineProperty(package$kvision, 'ImaskModule', {
    get: ImaskModule_getInstance
  });
  var package$form = package$kvision.form || (package$kvision.form = {});
  var package$text = package$form.text || (package$form.text = {});
  package$text.Imask = Imask;
  package$text.ImaskFactory = ImaskFactory;
  Object.defineProperty(MaskOverwrite, 'TRUE', {
    get: MaskOverwrite$TRUE_getInstance
  });
  Object.defineProperty(MaskOverwrite, 'FALSE', {
    get: MaskOverwrite$FALSE_getInstance
  });
  Object.defineProperty(MaskOverwrite, 'SHIFT', {
    get: MaskOverwrite$SHIFT_getInstance
  });
  package$text.MaskOverwrite = MaskOverwrite;
  Object.defineProperty(MaskAutofix, 'TRUE', {
    get: MaskAutofix$TRUE_getInstance
  });
  Object.defineProperty(MaskAutofix, 'FALSE', {
    get: MaskAutofix$FALSE_getInstance
  });
  Object.defineProperty(MaskAutofix, 'PAD', {
    get: MaskAutofix$PAD_getInstance
  });
  package$text.MaskAutofix = MaskAutofix;
  package$text.PatternMask = PatternMask;
  $$importsForInline$$['kvision-js-legacy'] = $module$kvision_js_legacy;
  package$text.toJs_m2o24s$ = toJs;
  package$text.RangeMask = RangeMask;
  package$text.toJs_tp5iwv$ = toJs_0;
  package$text.EnumMask = EnumMask;
  package$text.toJs_uvn3t$ = toJs_1;
  package$text.NumberMask = NumberMask;
  package$text.toJs_1wur4w$ = toJs_2;
  package$text.ImaskOptions = ImaskOptions;
  package$text.toJs_pxwpxn$ = toJs_3;
  Kotlin.defineModule('kvision-kvision-imask-js-legacy', _);
  return _;
}));
