(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kvision-js-legacy', 'kvision-kvision-state-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kvision-js-legacy'), require('kvision-kvision-state-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-datacontainer-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kvision-kvision-datacontainer-js-legacy'.");
    }
    if (typeof this['kvision-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-datacontainer-js-legacy'. Its dependency 'kvision-js-legacy' was not found. Please, check whether 'kvision-js-legacy' is loaded prior to 'kvision-kvision-datacontainer-js-legacy'.");
    }
    if (typeof this['kvision-kvision-state-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-datacontainer-js-legacy'. Its dependency 'kvision-kvision-state-js-legacy' was not found. Please, check whether 'kvision-kvision-state-js-legacy' is loaded prior to 'kvision-kvision-datacontainer-js-legacy'.");
    }
    root['kvision-kvision-datacontainer-js-legacy'] = factory(typeof this['kvision-kvision-datacontainer-js-legacy'] === 'undefined' ? {} : this['kvision-kvision-datacontainer-js-legacy'], kotlin, this['kvision-js-legacy'], this['kvision-kvision-state-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kvision_js_legacy, $module$kvision_kvision_state_js_legacy) {
  'use strict';
  var Unit = Kotlin.kotlin.Unit;
  var ObservableProperty = Kotlin.kotlin.properties.ObservableProperty;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var throwCCE = Kotlin.throwCCE;
  var Widget = $module$kvision_js_legacy.io.kvision.core.Widget;
  var ObservableList = $module$kvision_kvision_state_js_legacy.io.kvision.state.ObservableList;
  var Container = $module$kvision_js_legacy.io.kvision.core.Container;
  var VPanel = $module$kvision_js_legacy.io.kvision.panel.VPanel;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var sortedWith = Kotlin.kotlin.collections.sortedWith_eknfly$;
  var wrapFunction = Kotlin.wrapFunction;
  var Comparator = Kotlin.kotlin.Comparator;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  DataComponent$obs$ObjectLiteral.prototype = Object.create(ObservableProperty.prototype);
  DataComponent$obs$ObjectLiteral.prototype.constructor = DataComponent$obs$ObjectLiteral;
  SorterType.prototype = Object.create(Enum.prototype);
  SorterType.prototype.constructor = SorterType;
  DataContainer.prototype = Object.create(Widget.prototype);
  DataContainer.prototype.constructor = DataContainer;
  function DataComponent() {
  }
  function DataComponent$obs$ObjectLiteral(this$DataComponent, initialValue) {
    this.this$DataComponent = this$DataComponent;
    ObservableProperty.call(this, initialValue);
  }
  DataComponent$obs$ObjectLiteral.prototype.afterChange_jxtfl0$ = function (property, oldValue, newValue) {
    var tmp$;
    (tmp$ = this.this$DataComponent.container) != null ? (tmp$.update(), Unit) : null;
  };
  DataComponent$obs$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ObservableProperty]
  };
  DataComponent.prototype.obs_mh5how$ = function (initialValue) {
    return new DataComponent$obs$ObjectLiteral(this, initialValue);
  };
  DataComponent.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DataComponent',
    interfaces: []
  };
  function BaseDataComponent() {
    this.container_2887ve$_0 = null;
  }
  Object.defineProperty(BaseDataComponent.prototype, 'container', {
    configurable: true,
    get: function () {
      return this.container_2887ve$_0;
    },
    set: function (container) {
      this.container_2887ve$_0 = container;
    }
  });
  BaseDataComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BaseDataComponent',
    interfaces: [DataComponent]
  };
  var compareBy$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  var compareByDescending$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(b), selector(a));
      };
    };
  });
  function SorterType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SorterType_initFields() {
    SorterType_initFields = function () {
    };
    SorterType$ASC_instance = new SorterType('ASC', 0);
    SorterType$DESC_instance = new SorterType('DESC', 1);
  }
  var SorterType$ASC_instance;
  function SorterType$ASC_getInstance() {
    SorterType_initFields();
    return SorterType$ASC_instance;
  }
  var SorterType$DESC_instance;
  function SorterType$DESC_getInstance() {
    SorterType_initFields();
    return SorterType$DESC_instance;
  }
  SorterType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SorterType',
    interfaces: [Enum]
  };
  function SorterType$values() {
    return [SorterType$ASC_getInstance(), SorterType$DESC_getInstance()];
  }
  SorterType.values = SorterType$values;
  function SorterType$valueOf(name) {
    switch (name) {
      case 'ASC':
        return SorterType$ASC_getInstance();
      case 'DESC':
        return SorterType$DESC_getInstance();
      default:
        throwISE('No enum constant io.kvision.data.SorterType.' + name);
    }
  }
  SorterType.valueOf_61zpoe$ = SorterType$valueOf;
  function DataContainer(model, factory, container, containerAdd, filter, sorter, sorterType, init) {
    if (containerAdd === void 0)
      containerAdd = null;
    if (filter === void 0)
      filter = null;
    if (sorter === void 0)
      sorter = null;
    if (sorterType === void 0)
      sorterType = DataContainer_init$lambda;
    if (init === void 0)
      init = null;
    Widget.call(this);
    this.model_0 = model;
    this.factory_0 = factory;
    this.container_0 = container;
    this.containerAdd_0 = containerAdd;
    this.filter_0 = filter;
    this.sorter_0 = sorter;
    this.sorterType_0 = sorterType;
    this.onUpdateHandler_8be2vx$ = null;
    this.container_0.parent = this;
    if (Kotlin.isType(this.model_0, ObservableList)) {
      this.model_0.onUpdate.add_11rb$(DataContainer_init$lambda_0(this));
    }
    this.update();
    init != null ? init(this) : null;
  }
  Object.defineProperty(DataContainer.prototype, 'visible', {
    configurable: true,
    get: function () {
      return this.container_0.visible;
    },
    set: function (value) {
      this.container_0.visible = value;
    }
  });
  DataContainer.prototype.add_87eobz$ = function (child) {
    this.container_0.add_87eobz$(child);
    return this;
  };
  DataContainer.prototype.add_pqktxj$ = function (position, child) {
    this.container_0.add_pqktxj$(position, child);
    return this;
  };
  DataContainer.prototype.addAll_xquxs0$ = function (children) {
    this.container_0.addAll_xquxs0$(children);
    return this;
  };
  DataContainer.prototype.remove_87eobz$ = function (child) {
    this.container_0.remove_87eobz$(child);
    return this;
  };
  DataContainer.prototype.removeAt_za3lpa$ = function (position) {
    this.container_0.removeAt_za3lpa$(position);
    return this;
  };
  DataContainer.prototype.removeAll = function () {
    this.container_0.removeAll();
    return this;
  };
  DataContainer.prototype.disposeAll = function () {
    this.container_0.disposeAll();
    return this;
  };
  DataContainer.prototype.getChildren = function () {
    return this.container_0.getChildren();
  };
  DataContainer.prototype.renderVNode = function () {
    return this.container_0.renderVNode();
  };
  function DataContainer$update$lambda$lambda(this$DataContainer) {
    return function (it) {
      var tmp$;
      return (tmp$ = this$DataContainer.sorter_0(it.first)) == null || Kotlin.isComparable(tmp$) ? tmp$ : throwCCE();
    };
  }
  function DataContainer$update$lambda$lambda_0(this$DataContainer) {
    return function (it) {
      var tmp$;
      return (tmp$ = this$DataContainer.sorter_0(it.first)) == null || Kotlin.isComparable(tmp$) ? tmp$ : throwCCE();
    };
  }
  function DataContainer$update$lambda(this$DataContainer) {
    return function () {
      var tmp$, tmp$_0;
      this$DataContainer.container_0.disposeAll();
      var $receiver = this$DataContainer.model_0;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$_1, tmp$_0_0;
      var index = 0;
      tmp$_1 = $receiver.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        destination.add_11rb$(to(item, checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0))));
      }
      var indexed = destination;
      if (this$DataContainer.sorter_0 != null) {
        switch (this$DataContainer.sorterType_0().name) {
          case 'ASC':
            tmp$ = sortedWith(indexed, new Comparator(compareBy$lambda(DataContainer$update$lambda$lambda(this$DataContainer))));
            break;
          case 'DESC':
            tmp$ = sortedWith(indexed, new Comparator(compareByDescending$lambda(DataContainer$update$lambda$lambda_0(this$DataContainer))));
            break;
          default:
            tmp$ = Kotlin.noWhenBranchMatched();
            break;
        }
      } else {
        tmp$ = indexed;
      }
      var sorted = tmp$;
      if (this$DataContainer.filter_0 != null) {
        var destination_0 = ArrayList_init_0();
        var tmp$_2;
        tmp$_2 = sorted.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if (this$DataContainer.filter_0(element.first))
            destination_0.add_11rb$(element);
        }
        tmp$_0 = destination_0;
      } else {
        tmp$_0 = sorted;
      }
      var filtered = tmp$_0;
      var destination_1 = ArrayList_init(collectionSizeOrDefault(filtered, 10));
      var tmp$_3;
      tmp$_3 = filtered.iterator();
      while (tmp$_3.hasNext()) {
        var item_0 = tmp$_3.next();
        var tmp$_4 = destination_1.add_11rb$;
        var this$DataContainer_0 = this$DataContainer;
        tmp$_4.call(destination_1, to(item_0.first, this$DataContainer_0.factory_0(this$DataContainer_0.container_0, item_0.first, item_0.second, this$DataContainer_0.model_0)));
      }
      var children = destination_1;
      var tmp$_5 = this$DataContainer.container_0.getChildren().isEmpty();
      if (tmp$_5) {
        tmp$_5 = !children.isEmpty();
      }
      if (tmp$_5) {
        if (this$DataContainer.containerAdd_0 != null) {
          var tmp$_6;
          tmp$_6 = children.iterator();
          while (tmp$_6.hasNext()) {
            var element_0 = tmp$_6.next();
            var this$DataContainer_1 = this$DataContainer;
            this$DataContainer_1.containerAdd_0(this$DataContainer_1.container_0, element_0.second, element_0.first);
          }
        } else {
          var tmp$_7 = this$DataContainer.container_0;
          var destination_2 = ArrayList_init(collectionSizeOrDefault(children, 10));
          var tmp$_8;
          tmp$_8 = children.iterator();
          while (tmp$_8.hasNext()) {
            var item_1 = tmp$_8.next();
            destination_2.add_11rb$(item_1.second);
          }
          tmp$_7.addAll_xquxs0$(destination_2);
        }
      }
      return Unit;
    };
  }
  DataContainer.prototype.update = function () {
    var tmp$;
    var tmp$_0;
    tmp$_0 = this.model_0.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (Kotlin.isType(element, DataComponent))
        element.container = this;
    }
    this.singleRender_klfg04$(DataContainer$update$lambda(this));
    (tmp$ = this.onUpdateHandler_8be2vx$) != null ? tmp$() : null;
  };
  DataContainer.prototype.onUpdate_o14v8n$ = function (handler) {
    this.onUpdateHandler_8be2vx$ = handler;
    return this;
  };
  DataContainer.prototype.clearOnUpdate = function () {
    this.onUpdateHandler_8be2vx$ = null;
    return this;
  };
  function DataContainer_init$lambda() {
    return SorterType$ASC_getInstance();
  }
  function DataContainer_init$lambda_0(this$DataContainer) {
    return function (it) {
      this$DataContainer.update();
      return Unit;
    };
  }
  DataContainer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DataContainer',
    interfaces: [DataUpdatable, Container, Widget]
  };
  function dataContainer$lambda() {
    return SorterType$ASC_getInstance();
  }
  function dataContainer($receiver, model, factory, container, containerAdd, filter, sorter, sorterType, init) {
    if (containerAdd === void 0)
      containerAdd = null;
    if (filter === void 0)
      filter = null;
    if (sorter === void 0)
      sorter = null;
    if (sorterType === void 0)
      sorterType = dataContainer$lambda;
    if (init === void 0)
      init = null;
    var dataContainer = new DataContainer(model, factory, container, containerAdd, filter, sorter, sorterType, init);
    $receiver.add_87eobz$(dataContainer);
    return dataContainer;
  }
  function dataContainer$lambda_0() {
    return SorterType$ASC_getInstance();
  }
  function dataContainer_0($receiver, model, factory, containerAdd, filter, sorter, sorterType, init) {
    if (containerAdd === void 0)
      containerAdd = null;
    if (filter === void 0)
      filter = null;
    if (sorter === void 0)
      sorter = null;
    if (sorterType === void 0)
      sorterType = dataContainer$lambda_0;
    if (init === void 0)
      init = null;
    var dataContainer = new DataContainer(model, factory, new VPanel(), containerAdd, filter, sorter, sorterType, init);
    $receiver.add_87eobz$(dataContainer);
    return dataContainer;
  }
  function DataUpdatable() {
  }
  DataUpdatable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DataUpdatable',
    interfaces: []
  };
  var package$io = _.io || (_.io = {});
  var package$kvision = package$io.kvision || (package$io.kvision = {});
  var package$data = package$kvision.data || (package$kvision.data = {});
  package$data.DataComponent = DataComponent;
  package$data.BaseDataComponent = BaseDataComponent;
  Object.defineProperty(SorterType, 'ASC', {
    get: SorterType$ASC_getInstance
  });
  Object.defineProperty(SorterType, 'DESC', {
    get: SorterType$DESC_getInstance
  });
  package$data.SorterType = SorterType;
  package$data.DataContainer = DataContainer;
  package$data.dataContainer_aryn6a$ = dataContainer;
  package$data.dataContainer_b6ffjz$ = dataContainer_0;
  package$data.DataUpdatable = DataUpdatable;
  BaseDataComponent.prototype.obs_mh5how$ = DataComponent.prototype.obs_mh5how$;
  DataContainer.prototype.invoke_4h7hma$ = Container.prototype.invoke_4h7hma$;
  DataContainer.prototype.unaryPlus_pdl1vz$ = Container.prototype.unaryPlus_pdl1vz$;
  Kotlin.defineModule('kvision-kvision-datacontainer-js-legacy', _);
  return _;
}));
