(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kvision-js-legacy', 'snabbdom', 'kvision-kvision-jquery-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kvision-js-legacy'), require('snabbdom'), require('kvision-kvision-jquery-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-bootstrap-spinner-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kvision-kvision-bootstrap-spinner-js-legacy'.");
    }
    if (typeof this['kvision-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-bootstrap-spinner-js-legacy'. Its dependency 'kvision-js-legacy' was not found. Please, check whether 'kvision-js-legacy' is loaded prior to 'kvision-kvision-bootstrap-spinner-js-legacy'.");
    }
    if (typeof snabbdom === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-bootstrap-spinner-js-legacy'. Its dependency 'snabbdom' was not found. Please, check whether 'snabbdom' is loaded prior to 'kvision-kvision-bootstrap-spinner-js-legacy'.");
    }
    if (typeof this['kvision-kvision-jquery-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-bootstrap-spinner-js-legacy'. Its dependency 'kvision-kvision-jquery-js-legacy' was not found. Please, check whether 'kvision-kvision-jquery-js-legacy' is loaded prior to 'kvision-kvision-bootstrap-spinner-js-legacy'.");
    }
    root['kvision-kvision-bootstrap-spinner-js-legacy'] = factory(typeof this['kvision-kvision-bootstrap-spinner-js-legacy'] === 'undefined' ? {} : this['kvision-kvision-bootstrap-spinner-js-legacy'], kotlin, this['kvision-js-legacy'], snabbdom, this['kvision-kvision-jquery-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kvision_js_legacy, $module$snabbdom, $module$kvision_kvision_jquery_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ModuleInitializer = $module$kvision_js_legacy.io.kvision.ModuleInitializer;
  var NumberFormControl = $module$kvision_js_legacy.io.kvision.form.NumberFormControl;
  var SimplePanel = $module$kvision_js_legacy.io.kvision.panel.SimplePanel;
  var i18n = $module$kvision_js_legacy.io.kvision.i18n;
  var FieldLabel = $module$kvision_js_legacy.io.kvision.form.FieldLabel;
  var InvalidFeedback = $module$kvision_js_legacy.io.kvision.form.InvalidFeedback;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var MutableState = $module$kvision_js_legacy.io.kvision.state.MutableState;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var PropertyMetadata = Kotlin.PropertyMetadata;
  var h = $module$snabbdom.h;
  var Widget = $module$kvision_js_legacy.io.kvision.core.Widget;
  var numberToDouble = Kotlin.numberToDouble;
  var ensureNotNull = Kotlin.ensureNotNull;
  var Unit = Kotlin.kotlin.Unit;
  var getElementJQuery = $module$kvision_kvision_jquery_js_legacy.io.kvision.core.getElementJQuery_tqt9mm$;
  var throwCCE = Kotlin.throwCCE;
  var equals = Kotlin.equals;
  var getElementJQueryD = $module$kvision_kvision_jquery_js_legacy.io.kvision.core.getElementJQueryD_tqt9mm$;
  var bindAllJQueryListeners = $module$kvision_kvision_jquery_js_legacy.io.kvision.core.bindAllJQueryListeners_yw480n$;
  var removeAllJQueryListeners = $module$kvision_kvision_jquery_js_legacy.io.kvision.core.removeAllJQueryListeners_yw480n$;
  var replace = Kotlin.kotlin.text.replace_680rmw$;
  var toDoubleOrNull = Kotlin.kotlin.text.toDoubleOrNull_pdl1vz$;
  var GenericFormComponent = $module$kvision_js_legacy.io.kvision.form.GenericFormComponent;
  var FormInput = $module$kvision_js_legacy.io.kvision.form.FormInput;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Widget$Widget$RefreshDelegateProvider_init = $module$kvision_js_legacy.io.kvision.core.Widget.RefreshDelegateProvider;
  var Object_init = Object;
  Spinner.prototype = Object.create(SimplePanel.prototype);
  Spinner.prototype.constructor = Spinner;
  ButtonsType.prototype = Object.create(Enum.prototype);
  ButtonsType.prototype.constructor = ButtonsType;
  ForceType.prototype = Object.create(Enum.prototype);
  ForceType.prototype.constructor = ForceType;
  SpinnerInput.prototype = Object.create(Widget.prototype);
  SpinnerInput.prototype.constructor = SpinnerInput;
  function BootstrapSpinnerModule() {
    BootstrapSpinnerModule_instance = this;
  }
  BootstrapSpinnerModule.prototype.initialize = function () {
    require('bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.css');
    require('bootstrap-touchspin');
  };
  BootstrapSpinnerModule.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BootstrapSpinnerModule',
    interfaces: [ModuleInitializer]
  };
  var BootstrapSpinnerModule_instance = null;
  function BootstrapSpinnerModule_getInstance() {
    if (BootstrapSpinnerModule_instance === null) {
      new BootstrapSpinnerModule();
    }
    return BootstrapSpinnerModule_instance;
  }
  function Spinner(value, name, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, label, rich, init) {
    Spinner$Companion_getInstance();
    if (value === void 0)
      value = null;
    if (name === void 0)
      name = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    if (step === void 0)
      step = 1;
    if (decimals === void 0)
      decimals = 0;
    if (buttonsType === void 0)
      buttonsType = ButtonsType$VERTICAL_getInstance();
    if (forceType === void 0)
      forceType = ForceType$NONE_getInstance();
    if (buttonStyle === void 0)
      buttonStyle = null;
    if (decimalSeparator === void 0)
      decimalSeparator = i18n.I18n.detectDecimalSeparator();
    if (label === void 0)
      label = null;
    if (rich === void 0)
      rich = false;
    if (init === void 0)
      init = null;
    SimplePanel.call(this, 'form-group kv-mb-3');
    this.buttonsType = buttonsType;
    this.idc = 'kv_form_spinner_' + Spinner$Companion_getInstance().counter_8be2vx$;
    var $receiver = new SpinnerInput(value, min, max, step, decimals, this.buttonsType, forceType, buttonStyle, decimalSeparator);
    var closure$name = name;
    $receiver.id = this.idc;
    $receiver.name = closure$name;
    this.input_cgpwch$_0 = $receiver;
    this.flabel_dz4u4l$_0 = new FieldLabel(this.idc, label, rich, 'form-label');
    var $receiver_0 = new InvalidFeedback();
    $receiver_0.visible = false;
    this.invalidFeedback_m6x2oh$_0 = $receiver_0;
    var tmp$;
    this.input.eventTarget = this;
    this.addPrivate_87eobz$(this.flabel);
    this.addPrivate_87eobz$(this.input);
    this.addPrivate_87eobz$(this.invalidFeedback);
    tmp$ = Spinner$Companion_getInstance().counter_8be2vx$;
    Spinner$Companion_getInstance().counter_8be2vx$ = tmp$ + 1 | 0;
    init != null ? init(this) : null;
  }
  Object.defineProperty(Spinner.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.input.value;
    },
    set: function (value) {
      this.input.value = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'startValue', {
    configurable: true,
    get: function () {
      return this.input.startValue;
    },
    set: function (value) {
      this.input.startValue = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'min', {
    configurable: true,
    get: function () {
      return this.input.min;
    },
    set: function (value) {
      this.input.min = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'max', {
    configurable: true,
    get: function () {
      return this.input.max;
    },
    set: function (value) {
      this.input.max = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'step', {
    configurable: true,
    get: function () {
      return this.input.step;
    },
    set: function (value) {
      this.input.step = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'decimals', {
    configurable: true,
    get: function () {
      return this.input.decimals;
    },
    set: function (value) {
      this.input.decimals = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'forceType', {
    configurable: true,
    get: function () {
      return this.input.forceType;
    },
    set: function (value) {
      this.input.forceType = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'buttonStyle', {
    configurable: true,
    get: function () {
      return this.input.buttonStyle;
    },
    set: function (value) {
      this.input.buttonStyle = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'decimalSeparator', {
    configurable: true,
    get: function () {
      return this.input.decimalSeparator;
    },
    set: function (value) {
      this.input.decimalSeparator = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'placeholder', {
    configurable: true,
    get: function () {
      return this.input.placeholder;
    },
    set: function (value) {
      this.input.placeholder = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'autofocus', {
    configurable: true,
    get: function () {
      return this.input.autofocus;
    },
    set: function (value) {
      this.input.autofocus = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.input.readonly;
    },
    set: function (value) {
      this.input.readonly = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'label', {
    configurable: true,
    get: function () {
      return this.flabel.content;
    },
    set: function (value) {
      this.flabel.content = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'rich', {
    configurable: true,
    get: function () {
      return this.flabel.rich;
    },
    set: function (value) {
      this.flabel.rich = value;
    }
  });
  Object.defineProperty(Spinner.prototype, 'validatorError', {
    configurable: true,
    get: function () {
      return Kotlin.callGetter(this, NumberFormControl.prototype, 'validatorError');
    },
    set: function (value) {
      Kotlin.callSetter(this, NumberFormControl.prototype, 'validatorError', value);
      if (value != null) {
        this.input.addSurroundingCssClass_61zpoe$('is-invalid');
      } else {
        this.input.removeSurroundingCssClass_61zpoe$('is-invalid');
      }
    }
  });
  Object.defineProperty(Spinner.prototype, 'input', {
    configurable: true,
    get: function () {
      return this.input_cgpwch$_0;
    }
  });
  Object.defineProperty(Spinner.prototype, 'flabel', {
    configurable: true,
    get: function () {
      return this.flabel_dz4u4l$_0;
    }
  });
  Object.defineProperty(Spinner.prototype, 'invalidFeedback', {
    configurable: true,
    get: function () {
      return this.invalidFeedback_m6x2oh$_0;
    }
  });
  Spinner.prototype.buildClassSet_xutoed$ = function (classSetBuilder) {
    SimplePanel.prototype.buildClassSet_xutoed$.call(this, classSetBuilder);
    if (this.validatorError != null) {
      classSetBuilder.add_61zpoe$('text-danger');
    }
  };
  Spinner.prototype.setEventListener_a1up2z$ = function (block) {
    return this.input.setEventListener_a1up2z$(block);
  };
  Spinner.prototype.removeEventListener_za3lpa$ = function (id) {
    this.input.removeEventListener_za3lpa$(id);
    return this;
  };
  Spinner.prototype.removeEventListeners = function () {
    this.input.removeEventListeners();
    return this;
  };
  Spinner.prototype.getValueAsString = function () {
    return this.input.getValueAsString();
  };
  Spinner.prototype.spinUp = function () {
    this.input.spinUp();
    return this;
  };
  Spinner.prototype.spinDown = function () {
    this.input.spinDown();
    return this;
  };
  Spinner.prototype.focus = function () {
    this.input.focus();
  };
  Spinner.prototype.blur = function () {
    this.input.blur();
  };
  Spinner.prototype.styleForHorizontalFormPanel_fn6884$ = function (horizontalRatio) {
    this.addCssClass_61zpoe$('row');
    this.addCssClass_61zpoe$('kv-control-horiz');
    this.flabel.addCssClass_61zpoe$('col-sm-' + horizontalRatio.labels);
    this.flabel.addCssClass_61zpoe$('col-form-label');
    this.input.addSurroundingCssClass_61zpoe$('col-sm-' + horizontalRatio.fields);
    this.invalidFeedback.addCssClass_61zpoe$('offset-sm-' + horizontalRatio.labels);
    this.invalidFeedback.addCssClass_61zpoe$('col-sm-' + horizontalRatio.fields);
  };
  Spinner.prototype.getState = function () {
    return this.input.getState();
  };
  Spinner.prototype.subscribe_qlkmfe$ = function (observer) {
    return this.input.subscribe_qlkmfe$(observer);
  };
  Spinner.prototype.setState_11rb$ = function (state) {
    this.input.setState_11rb$(state);
  };
  function Spinner$Companion() {
    Spinner$Companion_instance = this;
    this.counter_8be2vx$ = 0;
  }
  Spinner$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Spinner$Companion_instance = null;
  function Spinner$Companion_getInstance() {
    if (Spinner$Companion_instance === null) {
      new Spinner$Companion();
    }
    return Spinner$Companion_instance;
  }
  Spinner.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Spinner',
    interfaces: [MutableState, NumberFormControl, SimplePanel]
  };
  function spinner($receiver, value, name, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, label, rich, init) {
    if (value === void 0)
      value = null;
    if (name === void 0)
      name = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    if (step === void 0)
      step = 1;
    if (decimals === void 0)
      decimals = 0;
    if (buttonsType === void 0)
      buttonsType = ButtonsType$VERTICAL_getInstance();
    if (forceType === void 0)
      forceType = ForceType$NONE_getInstance();
    if (buttonStyle === void 0)
      buttonStyle = null;
    if (decimalSeparator === void 0)
      decimalSeparator = i18n.I18n.detectDecimalSeparator();
    if (label === void 0)
      label = null;
    if (rich === void 0)
      rich = false;
    if (init === void 0)
      init = null;
    var spinner = new Spinner(value, name, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, label, rich, init);
    $receiver.add_87eobz$(spinner);
    return spinner;
  }
  function Widget$refreshOnUpdate$lambda(this$Widget) {
    return function (it) {
      this$Widget.refresh();
      return Unit;
    };
  }
  function Widget$refreshOnUpdate$lambda_0(this$Widget) {
    return function (it) {
      this$Widget.refresh();
      return Unit;
    };
  }
  function ButtonsType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ButtonsType_initFields() {
    ButtonsType_initFields = function () {
    };
    ButtonsType$NONE_instance = new ButtonsType('NONE', 0);
    ButtonsType$HORIZONTAL_instance = new ButtonsType('HORIZONTAL', 1);
    ButtonsType$VERTICAL_instance = new ButtonsType('VERTICAL', 2);
  }
  var ButtonsType$NONE_instance;
  function ButtonsType$NONE_getInstance() {
    ButtonsType_initFields();
    return ButtonsType$NONE_instance;
  }
  var ButtonsType$HORIZONTAL_instance;
  function ButtonsType$HORIZONTAL_getInstance() {
    ButtonsType_initFields();
    return ButtonsType$HORIZONTAL_instance;
  }
  var ButtonsType$VERTICAL_instance;
  function ButtonsType$VERTICAL_getInstance() {
    ButtonsType_initFields();
    return ButtonsType$VERTICAL_instance;
  }
  ButtonsType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ButtonsType',
    interfaces: [Enum]
  };
  function ButtonsType$values() {
    return [ButtonsType$NONE_getInstance(), ButtonsType$HORIZONTAL_getInstance(), ButtonsType$VERTICAL_getInstance()];
  }
  ButtonsType.values = ButtonsType$values;
  function ButtonsType$valueOf(name) {
    switch (name) {
      case 'NONE':
        return ButtonsType$NONE_getInstance();
      case 'HORIZONTAL':
        return ButtonsType$HORIZONTAL_getInstance();
      case 'VERTICAL':
        return ButtonsType$VERTICAL_getInstance();
      default:
        throwISE('No enum constant io.kvision.form.spinner.ButtonsType.' + name);
    }
  }
  ButtonsType.valueOf_61zpoe$ = ButtonsType$valueOf;
  function ForceType(name, ordinal, value) {
    Enum.call(this);
    this.value_8be2vx$ = value;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ForceType_initFields() {
    ForceType_initFields = function () {
    };
    ForceType$NONE_instance = new ForceType('NONE', 0, 'none');
    ForceType$ROUND_instance = new ForceType('ROUND', 1, 'round');
    ForceType$FLOOR_instance = new ForceType('FLOOR', 2, 'floor');
    ForceType$CEIL_instance = new ForceType('CEIL', 3, 'ceil');
  }
  var ForceType$NONE_instance;
  function ForceType$NONE_getInstance() {
    ForceType_initFields();
    return ForceType$NONE_instance;
  }
  var ForceType$ROUND_instance;
  function ForceType$ROUND_getInstance() {
    ForceType_initFields();
    return ForceType$ROUND_instance;
  }
  var ForceType$FLOOR_instance;
  function ForceType$FLOOR_getInstance() {
    ForceType_initFields();
    return ForceType$FLOOR_instance;
  }
  var ForceType$CEIL_instance;
  function ForceType$CEIL_getInstance() {
    ForceType_initFields();
    return ForceType$CEIL_instance;
  }
  ForceType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ForceType',
    interfaces: [Enum]
  };
  function ForceType$values() {
    return [ForceType$NONE_getInstance(), ForceType$ROUND_getInstance(), ForceType$FLOOR_getInstance(), ForceType$CEIL_getInstance()];
  }
  ForceType.values = ForceType$values;
  function ForceType$valueOf(name) {
    switch (name) {
      case 'NONE':
        return ForceType$NONE_getInstance();
      case 'ROUND':
        return ForceType$ROUND_getInstance();
      case 'FLOOR':
        return ForceType$FLOOR_getInstance();
      case 'CEIL':
        return ForceType$CEIL_getInstance();
      default:
        throwISE('No enum constant io.kvision.form.spinner.ForceType.' + name);
    }
  }
  ForceType.valueOf_61zpoe$ = ForceType$valueOf;
  var DEFAULT_STEP;
  function SpinnerInput(value, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, className, init) {
    SpinnerInput$Companion_getInstance();
    if (value === void 0)
      value = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    if (step === void 0)
      step = 1;
    if (decimals === void 0)
      decimals = 0;
    if (buttonsType === void 0)
      buttonsType = ButtonsType$VERTICAL_getInstance();
    if (forceType === void 0)
      forceType = ForceType$NONE_getInstance();
    if (buttonStyle === void 0)
      buttonStyle = null;
    if (decimalSeparator === void 0)
      decimalSeparator = i18n.I18n.detectDecimalSeparator();
    if (className === void 0)
      className = null;
    if (init === void 0)
      init = null;
    var tmp$;
    Widget.call(this, ((tmp$ = className != null ? className + ' ' : null) != null ? tmp$ : '') + 'form-control');
    this.buttonsType = buttonsType;
    this.observers = ArrayList_init();
    this.value_1500ru$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, value, SpinnerInput$value$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$value_metadata);
    this.startValue_ilyzd6$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, value, SpinnerInput$startValue$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$startValue_metadata);
    this.min_ck8l0p$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, min, SpinnerInput$min$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$min_metadata);
    this.max_ck8fbr$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, max, SpinnerInput$max$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$max_metadata);
    this.step_ydbgst$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, step, SpinnerInput$step$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$step_metadata);
    this.decimals_55azc9$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, decimals, SpinnerInput$decimals$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$decimals_metadata);
    this.forceType_hdcwba$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, forceType, SpinnerInput$forceType$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$forceType_metadata);
    this.buttonStyle_mrws70$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, buttonStyle, SpinnerInput$buttonStyle$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$buttonStyle_metadata);
    this.decimalSeparator_ru24jp$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, decimalSeparator, SpinnerInput$decimalSeparator$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$decimalSeparator_metadata);
    this.placeholder_tnj0iw$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$placeholder_metadata);
    this.name_ya8ir2$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$name_metadata);
    this.disabled_e48ns3$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, false, Widget$refreshOnUpdate$lambda(this))).provideDelegate_n5byny$(this, SpinnerInput$disabled_metadata);
    this.autofocus_hw313m$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$autofocus_metadata);
    this.readonly_t4vqsp$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$readonly_metadata);
    this.size_yd4v94$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$size_metadata);
    this.validationStatus_48ooby$_0 = (new Widget$Widget$RefreshDelegateProvider_init(this, null, Widget$refreshOnUpdate$lambda_0(this))).provideDelegate_n5byny$(this, SpinnerInput$validationStatus_metadata);
    this.siblings_3lugnc$_0 = null;
    this.useSnabbdomDistinctKey();
    this.addSurroundingCssClass_61zpoe$('kv-spinner');
    switch (this.buttonsType.name) {
      case 'NONE':
        this.addSurroundingCssClass_61zpoe$('kv-spinner-btn-none');
        break;
      case 'VERTICAL':
        this.addSurroundingCssClass_61zpoe$('kv-spinner-btn-vertical');
        break;
      case 'HORIZONTAL':
        this.addSurroundingCssClass_61zpoe$('kv-spinner-btn-horizontal');
        break;
      default:
        Kotlin.noWhenBranchMatched();
        break;
    }
    this.setInternalEventListener_a1up2z$(SpinnerInput_init$lambda);
    init != null ? init(this) : null;
  }
  var SpinnerInput$value_metadata = new PropertyMetadata('value');
  Object.defineProperty(SpinnerInput.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.value_1500ru$_0.getValue_fmbzy8$(this, SpinnerInput$value_metadata);
    },
    set: function (value) {
      this.value_1500ru$_0.setValue_19qrsr$(this, SpinnerInput$value_metadata, value);
    }
  });
  var SpinnerInput$startValue_metadata = new PropertyMetadata('startValue');
  Object.defineProperty(SpinnerInput.prototype, 'startValue', {
    configurable: true,
    get: function () {
      return this.startValue_ilyzd6$_0.getValue_fmbzy8$(this, SpinnerInput$startValue_metadata);
    },
    set: function (startValue) {
      this.startValue_ilyzd6$_0.setValue_19qrsr$(this, SpinnerInput$startValue_metadata, startValue);
    }
  });
  var SpinnerInput$min_metadata = new PropertyMetadata('min');
  Object.defineProperty(SpinnerInput.prototype, 'min', {
    configurable: true,
    get: function () {
      return this.min_ck8l0p$_0.getValue_fmbzy8$(this, SpinnerInput$min_metadata);
    },
    set: function (min) {
      this.min_ck8l0p$_0.setValue_19qrsr$(this, SpinnerInput$min_metadata, min);
    }
  });
  var SpinnerInput$max_metadata = new PropertyMetadata('max');
  Object.defineProperty(SpinnerInput.prototype, 'max', {
    configurable: true,
    get: function () {
      return this.max_ck8fbr$_0.getValue_fmbzy8$(this, SpinnerInput$max_metadata);
    },
    set: function (max) {
      this.max_ck8fbr$_0.setValue_19qrsr$(this, SpinnerInput$max_metadata, max);
    }
  });
  var SpinnerInput$step_metadata = new PropertyMetadata('step');
  Object.defineProperty(SpinnerInput.prototype, 'step', {
    configurable: true,
    get: function () {
      return this.step_ydbgst$_0.getValue_fmbzy8$(this, SpinnerInput$step_metadata);
    },
    set: function (step) {
      this.step_ydbgst$_0.setValue_19qrsr$(this, SpinnerInput$step_metadata, step);
    }
  });
  var SpinnerInput$decimals_metadata = new PropertyMetadata('decimals');
  Object.defineProperty(SpinnerInput.prototype, 'decimals', {
    configurable: true,
    get: function () {
      return this.decimals_55azc9$_0.getValue_fmbzy8$(this, SpinnerInput$decimals_metadata);
    },
    set: function (decimals) {
      this.decimals_55azc9$_0.setValue_19qrsr$(this, SpinnerInput$decimals_metadata, decimals);
    }
  });
  var SpinnerInput$forceType_metadata = new PropertyMetadata('forceType');
  Object.defineProperty(SpinnerInput.prototype, 'forceType', {
    configurable: true,
    get: function () {
      return this.forceType_hdcwba$_0.getValue_fmbzy8$(this, SpinnerInput$forceType_metadata);
    },
    set: function (forceType) {
      this.forceType_hdcwba$_0.setValue_19qrsr$(this, SpinnerInput$forceType_metadata, forceType);
    }
  });
  var SpinnerInput$buttonStyle_metadata = new PropertyMetadata('buttonStyle');
  Object.defineProperty(SpinnerInput.prototype, 'buttonStyle', {
    configurable: true,
    get: function () {
      return this.buttonStyle_mrws70$_0.getValue_fmbzy8$(this, SpinnerInput$buttonStyle_metadata);
    },
    set: function (buttonStyle) {
      this.buttonStyle_mrws70$_0.setValue_19qrsr$(this, SpinnerInput$buttonStyle_metadata, buttonStyle);
    }
  });
  var SpinnerInput$decimalSeparator_metadata = new PropertyMetadata('decimalSeparator');
  Object.defineProperty(SpinnerInput.prototype, 'decimalSeparator', {
    configurable: true,
    get: function () {
      return this.decimalSeparator_ru24jp$_0.getValue_fmbzy8$(this, SpinnerInput$decimalSeparator_metadata);
    },
    set: function (decimalSeparator) {
      this.decimalSeparator_ru24jp$_0.setValue_19qrsr$(this, SpinnerInput$decimalSeparator_metadata, decimalSeparator);
    }
  });
  var SpinnerInput$placeholder_metadata = new PropertyMetadata('placeholder');
  Object.defineProperty(SpinnerInput.prototype, 'placeholder', {
    configurable: true,
    get: function () {
      return this.placeholder_tnj0iw$_0.getValue_fmbzy8$(this, SpinnerInput$placeholder_metadata);
    },
    set: function (placeholder) {
      this.placeholder_tnj0iw$_0.setValue_19qrsr$(this, SpinnerInput$placeholder_metadata, placeholder);
    }
  });
  var SpinnerInput$name_metadata = new PropertyMetadata('name');
  Object.defineProperty(SpinnerInput.prototype, 'name', {
    configurable: true,
    get: function () {
      return this.name_ya8ir2$_0.getValue_fmbzy8$(this, SpinnerInput$name_metadata);
    },
    set: function (name) {
      this.name_ya8ir2$_0.setValue_19qrsr$(this, SpinnerInput$name_metadata, name);
    }
  });
  var SpinnerInput$disabled_metadata = new PropertyMetadata('disabled');
  Object.defineProperty(SpinnerInput.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.disabled_e48ns3$_0.getValue_fmbzy8$(this, SpinnerInput$disabled_metadata);
    },
    set: function (disabled) {
      this.disabled_e48ns3$_0.setValue_19qrsr$(this, SpinnerInput$disabled_metadata, disabled);
    }
  });
  var SpinnerInput$autofocus_metadata = new PropertyMetadata('autofocus');
  Object.defineProperty(SpinnerInput.prototype, 'autofocus', {
    configurable: true,
    get: function () {
      return this.autofocus_hw313m$_0.getValue_fmbzy8$(this, SpinnerInput$autofocus_metadata);
    },
    set: function (autofocus) {
      this.autofocus_hw313m$_0.setValue_19qrsr$(this, SpinnerInput$autofocus_metadata, autofocus);
    }
  });
  var SpinnerInput$readonly_metadata = new PropertyMetadata('readonly');
  Object.defineProperty(SpinnerInput.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.readonly_t4vqsp$_0.getValue_fmbzy8$(this, SpinnerInput$readonly_metadata);
    },
    set: function (readonly) {
      this.readonly_t4vqsp$_0.setValue_19qrsr$(this, SpinnerInput$readonly_metadata, readonly);
    }
  });
  var SpinnerInput$size_metadata = new PropertyMetadata('size');
  Object.defineProperty(SpinnerInput.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.size_yd4v94$_0.getValue_fmbzy8$(this, SpinnerInput$size_metadata);
    },
    set: function (size) {
      this.size_yd4v94$_0.setValue_19qrsr$(this, SpinnerInput$size_metadata, size);
    }
  });
  var SpinnerInput$validationStatus_metadata = new PropertyMetadata('validationStatus');
  Object.defineProperty(SpinnerInput.prototype, 'validationStatus', {
    configurable: true,
    get: function () {
      return this.validationStatus_48ooby$_0.getValue_fmbzy8$(this, SpinnerInput$validationStatus_metadata);
    },
    set: function (validationStatus) {
      this.validationStatus_48ooby$_0.setValue_19qrsr$(this, SpinnerInput$validationStatus_metadata, validationStatus);
    }
  });
  SpinnerInput.prototype.render = function () {
    return h('span', this.getSnOptSimple(), [this.render_61zpoe$('input')]);
  };
  SpinnerInput.prototype.buildClassSet_xutoed$ = function (classSetBuilder) {
    Widget.prototype.buildClassSet_xutoed$.call(this, classSetBuilder);
    classSetBuilder.add_vqcfem$(this.validationStatus);
    classSetBuilder.add_vqcfem$(this.size);
  };
  SpinnerInput.prototype.buildAttributeSet_34lhpl$ = function (attributeSetBuilder) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    Widget.prototype.buildAttributeSet_34lhpl$.call(this, attributeSetBuilder);
    attributeSetBuilder.add_puj7f4$('type', 'text');
    if ((tmp$ = this.startValue) != null) {
      attributeSetBuilder.add_puj7f4$('value', ensureNotNull(this.convertToString_f5zrvn$_0(numberToDouble(tmp$))));
    }
    if ((tmp$_0 = this.placeholder) != null) {
      attributeSetBuilder.add_puj7f4$('placeholder', this.translate_61zpoe$(tmp$_0));
    }
    if ((tmp$_1 = this.name) != null) {
      attributeSetBuilder.add_puj7f4$('name', tmp$_1);
    }
    if ((tmp$_2 = this.autofocus) != null) {
      if (tmp$_2) {
        attributeSetBuilder.add_puj7f4$('autofocus');
      }
    }
    if ((tmp$_3 = this.readonly) != null) {
      if (tmp$_3) {
        attributeSetBuilder.add_puj7f4$('readonly');
      }
    }
    if (this.disabled) {
      attributeSetBuilder.add_puj7f4$('disabled');
      if ((tmp$_4 = this.value) != null) {
        attributeSetBuilder.add_puj7f4$('value', ensureNotNull(this.convertToString_f5zrvn$_0(numberToDouble(tmp$_4))));
      }
    }
  };
  SpinnerInput.prototype.changeValue = function () {
    var tmp$, tmp$_0, tmp$_1;
    var v = (tmp$_0 = (tmp$ = getElementJQuery(this)) != null ? tmp$.val() : null) == null || typeof tmp$_0 === 'string' ? tmp$_0 : throwCCE();
    if (v != null && !equals(v, '')) {
      var tmp$_2;
      if ((tmp$_1 = this.convertToNumber_3079np$_0(v)) != null) {
        var tmp$_3, tmp$_4, tmp$_5, tmp$_6;
        tmp$_2 = this.min != null && tmp$_1 < ((tmp$_4 = (tmp$_3 = this.min) != null ? numberToDouble(tmp$_3) : null) != null ? tmp$_4 : 0.0) ? this.min : this.max != null && tmp$_1 > ((tmp$_6 = (tmp$_5 = this.max) != null ? numberToDouble(tmp$_5) : null) != null ? tmp$_6 : 0.0) ? this.max : tmp$_1;
      } else
        tmp$_2 = null;
      var newValue = tmp$_2;
      if (!equals(this.value, newValue)) {
        this.value = newValue;
      }
    } else {
      this.value = null;
    }
  };
  function SpinnerInput$afterInsert$lambda(this$SpinnerInput) {
    return function (e, f) {
      if (e.isTrigger != null) {
        var tmp$ = this$SpinnerInput;
        var $receiver = new Object_init();
        $receiver.detail = e;
        tmp$.dispatchEvent_nxedta$('change', $receiver);
      }
      return Unit;
    };
  }
  SpinnerInput.prototype.afterInsert_77isfd$ = function (node) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    (tmp$ = getElementJQueryD(this)) != null ? tmp$.TouchSpin(this.getSettingsObj_4mul4r$_0()) : null;
    this.siblings_3lugnc$_0 = (tmp$_1 = (tmp$_0 = getElementJQuery(this)) != null ? tmp$_0.parent('.bootstrap-touchspin') : null) != null ? tmp$_1.children('span') : null;
    (tmp$_2 = getElementJQuery(this)) != null ? tmp$_2.on('change', SpinnerInput$afterInsert$lambda(this)) : null;
    this.refreshState_nf0i3h$_0();
  };
  SpinnerInput.prototype.bindAllJQueryListeners = function () {
    bindAllJQueryListeners(this, this.jqueryListenersMap);
  };
  SpinnerInput.prototype.removeAllJQueryListeners = function () {
    removeAllJQueryListeners(this, this.jqueryListenersMap);
  };
  SpinnerInput.prototype.afterDestroy = function () {
    var tmp$;
    (tmp$ = this.siblings_3lugnc$_0) != null ? tmp$.remove() : null;
    this.siblings_3lugnc$_0 = null;
  };
  SpinnerInput.prototype.getValueAsString = function () {
    var tmp$;
    return (tmp$ = this.value) != null ? tmp$.toString() : null;
  };
  SpinnerInput.prototype.spinUp = function () {
    var tmp$;
    (tmp$ = getElementJQueryD(this)) != null ? tmp$.trigger('touchspin.uponce') : null;
    return this;
  };
  SpinnerInput.prototype.spinDown = function () {
    var tmp$;
    (tmp$ = getElementJQueryD(this)) != null ? tmp$.trigger('touchspin.downonce') : null;
    return this;
  };
  SpinnerInput.prototype.convertToString_f5zrvn$_0 = function (v) {
    return v != null ? this.decimalSeparator != null ? replace(v.toString(), '.', ensureNotNull(this.decimalSeparator)) : v.toString() : null;
  };
  SpinnerInput.prototype.convertToNumber_3079np$_0 = function (v) {
    var tmp$;
    return (tmp$ = v != null ? this.decimalSeparator != null ? replace(v, ensureNotNull(this.decimalSeparator), '.') : v : null) != null ? toDoubleOrNull(tmp$) : null;
  };
  SpinnerInput.prototype.refreshState_nf0i3h$_0 = function () {
    var tmp$, tmp$_0, tmp$_1;
    var tmp$_2;
    if ((tmp$ = this.value) != null) {
      var tmp$_3;
      tmp$_2 = (tmp$_3 = getElementJQuery(this)) != null ? tmp$_3.val(ensureNotNull(this.convertToString_f5zrvn$_0(numberToDouble(tmp$)))) : null;
    } else
      tmp$_2 = null;
    (tmp$_1 = tmp$_2) != null ? tmp$_1 : (tmp$_0 = getElementJQueryD(this)) != null ? tmp$_0.val(null) : null;
  };
  SpinnerInput.prototype.refreshSpinner_t125p7$_0 = function () {
    var tmp$;
    (tmp$ = getElementJQueryD(this)) != null ? tmp$.trigger('touchspin.updatesettings', this.getSettingsObj_4mul4r$_0()) : null;
  };
  function SpinnerInput$getSettingsObj$lambda(this$SpinnerInput) {
    return function (a) {
      return replace(a, ensureNotNull(this$SpinnerInput.decimalSeparator), '.');
    };
  }
  function SpinnerInput$getSettingsObj$lambda_0(this$SpinnerInput) {
    return function (b) {
      return replace(b, '.', ensureNotNull(this$SpinnerInput.decimalSeparator));
    };
  }
  SpinnerInput.prototype.getSettingsObj_4mul4r$_0 = function () {
    var tmp$, tmp$_0;
    var verticalbuttons = this.buttonsType === ButtonsType$VERTICAL_getInstance() || this.buttonsType === ButtonsType$NONE_getInstance();
    var style = this.buttonStyle;
    if (this.decimalSeparator != null) {
      tmp$ = SpinnerInput$getSettingsObj$lambda(this);
    } else
      tmp$ = undefined;
    var callbackBefore = tmp$;
    if (this.decimalSeparator != null) {
      tmp$_0 = SpinnerInput$getSettingsObj$lambda_0(this);
    } else
      tmp$_0 = undefined;
    var callbackAfter = tmp$_0;
    var $receiver = new Object_init();
    $receiver.min = this.min;
    $receiver.max = this.max;
    $receiver.step = this.step;
    $receiver.decimals = this.decimals;
    $receiver.verticalbuttons = verticalbuttons;
    $receiver.forcestepdivisibility = this.forceType.value_8be2vx$;
    if (style != null) {
      $receiver.buttonup_class = 'btn ' + style.className;
      $receiver.buttondown_class = 'btn ' + style.className;
    } else {
      $receiver.buttonup_class = 'btn btn-secondary';
      $receiver.buttondown_class = 'btn btn-secondary';
    }
    if (verticalbuttons) {
      $receiver.verticalup = '\u25B2';
      $receiver.verticaldown = '\u25BC';
    }
    if (this.decimalSeparator != null) {
      $receiver.callback_before_calculation = callbackBefore;
      $receiver.callback_after_calculation = callbackAfter;
    }
    return $receiver;
  };
  SpinnerInput.prototype.getState = function () {
    return this.value;
  };
  function SpinnerInput$subscribe$lambda(this$SpinnerInput, closure$observer) {
    return function () {
      var $receiver = this$SpinnerInput.observers;
      var element = closure$observer;
      $receiver.remove_11rb$(element);
      return Unit;
    };
  }
  SpinnerInput.prototype.subscribe_qlkmfe$ = function (observer) {
    this.observers.add_11rb$(observer);
    observer(this.value);
    return SpinnerInput$subscribe$lambda(this, observer);
  };
  SpinnerInput.prototype.setState_11rb$ = function (state) {
    this.value = state;
  };
  function SpinnerInput$Companion() {
    SpinnerInput$Companion_instance = this;
    BootstrapSpinnerModule_getInstance().initialize();
  }
  SpinnerInput$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SpinnerInput$Companion_instance = null;
  function SpinnerInput$Companion_getInstance() {
    if (SpinnerInput$Companion_instance === null) {
      new SpinnerInput$Companion();
    }
    return SpinnerInput$Companion_instance;
  }
  function SpinnerInput$value$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshState_nf0i3h$_0();
      var tmp$;
      tmp$ = this$SpinnerInput.observers.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        element(it);
      }
      return Unit;
    };
  }
  function SpinnerInput$startValue$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.value = it;
      this$SpinnerInput.refresh();
      return Unit;
    };
  }
  function SpinnerInput$min$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$max$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$step$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$decimals$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$forceType$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$buttonStyle$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput$decimalSeparator$lambda(this$SpinnerInput) {
    return function (it) {
      this$SpinnerInput.refreshSpinner_t125p7$_0();
      return Unit;
    };
  }
  function SpinnerInput_init$lambda$lambda(this$) {
    return function (it) {
      this$.self.changeValue();
      return Unit;
    };
  }
  function SpinnerInput_init$lambda($receiver) {
    $receiver.change = SpinnerInput_init$lambda$lambda($receiver);
    return Unit;
  }
  SpinnerInput.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SpinnerInput',
    interfaces: [MutableState, FormInput, GenericFormComponent, Widget]
  };
  function spinnerInput($receiver, value, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, className, init) {
    if (value === void 0)
      value = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    if (step === void 0)
      step = 1;
    if (decimals === void 0)
      decimals = 0;
    if (buttonsType === void 0)
      buttonsType = ButtonsType$VERTICAL_getInstance();
    if (forceType === void 0)
      forceType = ForceType$NONE_getInstance();
    if (buttonStyle === void 0)
      buttonStyle = null;
    if (decimalSeparator === void 0)
      decimalSeparator = i18n.I18n.detectDecimalSeparator();
    if (className === void 0)
      className = null;
    if (init === void 0)
      init = null;
    var spinnerInput = new SpinnerInput(value, min, max, step, decimals, buttonsType, forceType, buttonStyle, decimalSeparator, className, init);
    $receiver.add_87eobz$(spinnerInput);
    return spinnerInput;
  }
  var package$io = _.io || (_.io = {});
  var package$kvision = package$io.kvision || (package$io.kvision = {});
  Object.defineProperty(package$kvision, 'BootstrapSpinnerModule', {
    get: BootstrapSpinnerModule_getInstance
  });
  Object.defineProperty(Spinner, 'Companion', {
    get: Spinner$Companion_getInstance
  });
  var package$form = package$kvision.form || (package$kvision.form = {});
  var package$spinner = package$form.spinner || (package$form.spinner = {});
  package$spinner.Spinner = Spinner;
  package$spinner.spinner_njmcp2$ = spinner;
  Object.defineProperty(ButtonsType, 'NONE', {
    get: ButtonsType$NONE_getInstance
  });
  Object.defineProperty(ButtonsType, 'HORIZONTAL', {
    get: ButtonsType$HORIZONTAL_getInstance
  });
  Object.defineProperty(ButtonsType, 'VERTICAL', {
    get: ButtonsType$VERTICAL_getInstance
  });
  package$spinner.ButtonsType = ButtonsType;
  Object.defineProperty(ForceType, 'NONE', {
    get: ForceType$NONE_getInstance
  });
  Object.defineProperty(ForceType, 'ROUND', {
    get: ForceType$ROUND_getInstance
  });
  Object.defineProperty(ForceType, 'FLOOR', {
    get: ForceType$FLOOR_getInstance
  });
  Object.defineProperty(ForceType, 'CEIL', {
    get: ForceType$CEIL_getInstance
  });
  package$spinner.ForceType = ForceType;
  Object.defineProperty(package$spinner, 'DEFAULT_STEP_8be2vx$', {
    get: function () {
      return DEFAULT_STEP;
    }
  });
  $$importsForInline$$['kvision-js-legacy'] = $module$kvision_js_legacy;
  Object.defineProperty(SpinnerInput, 'Companion', {
    get: SpinnerInput$Companion_getInstance
  });
  package$spinner.SpinnerInput = SpinnerInput;
  package$spinner.spinnerInput_nel714$ = spinnerInput;
  Object.defineProperty(Spinner.prototype, 'disabled', Object.getOwnPropertyDescriptor(NumberFormControl.prototype, 'disabled'));
  Object.defineProperty(Spinner.prototype, 'name', Object.getOwnPropertyDescriptor(NumberFormControl.prototype, 'name'));
  Object.defineProperty(Spinner.prototype, 'size', Object.getOwnPropertyDescriptor(NumberFormControl.prototype, 'size'));
  Object.defineProperty(Spinner.prototype, 'validationStatus', Object.getOwnPropertyDescriptor(NumberFormControl.prototype, 'validationStatus'));
  Spinner.prototype.getValue = NumberFormControl.prototype.getValue;
  Spinner.prototype.setValue_s8jyv4$ = NumberFormControl.prototype.setValue_s8jyv4$;
  Spinner.prototype.styleForInlineFormPanel = NumberFormControl.prototype.styleForInlineFormPanel;
  Spinner.prototype.styleForVerticalFormPanel = NumberFormControl.prototype.styleForVerticalFormPanel;
  DEFAULT_STEP = 1;
  Kotlin.defineModule('kvision-kvision-bootstrap-spinner-js-legacy', _);
  return _;
}));
