/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk;

import io.kuzzle.sdk.controllers.AuthController;
import io.kuzzle.sdk.controllers.BulkController;
import io.kuzzle.sdk.controllers.CollectionController;
import io.kuzzle.sdk.controllers.DocumentController;
import io.kuzzle.sdk.controllers.IndexController;
import io.kuzzle.sdk.controllers.RealtimeController;
import io.kuzzle.sdk.controllers.ServerController;
import io.kuzzle.sdk.coreClasses.RequestPayload;
import io.kuzzle.sdk.coreClasses.exceptions.ApiErrorException;
import io.kuzzle.sdk.coreClasses.exceptions.InvalidJSON;
import io.kuzzle.sdk.coreClasses.exceptions.KuzzleExceptionCode;
import io.kuzzle.sdk.coreClasses.exceptions.NotConnectedException;
import io.kuzzle.sdk.coreClasses.json.JsonSerializer;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import io.kuzzle.sdk.coreClasses.responses.ErrorResponse;
import io.kuzzle.sdk.coreClasses.responses.Response;
import io.kuzzle.sdk.events.EventManager;
import io.kuzzle.sdk.events.MessageReceivedEvent;
import io.kuzzle.sdk.events.NetworkStateChangeEvent;
import io.kuzzle.sdk.events.RequestErrorEvent;
import io.kuzzle.sdk.events.RoomMessageEvent;
import io.kuzzle.sdk.events.TokenExpiredEvent;
import io.kuzzle.sdk.events.UnhandledExceptionEvent;
import io.kuzzle.sdk.protocol.AbstractProtocol;
import io.kuzzle.sdk.protocol.ProtocolState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0010\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u0002072\u0006\u0010:\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0002072\u0006\u0010:\u001a\u00020?H\u0002J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010@\u001a\u00020AJ\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010@\u001a\u00020\u0001J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010@\u001a\u00020\fJ$\u0010@\u001a\b\u0012\u0004\u0012\u00020*0)2\u0016\u0010@\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010BR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R6\u0010'\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0(j\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/kuzzle/sdk/Kuzzle;", "", "protocol", "Lio/kuzzle/sdk/protocol/AbstractProtocol;", "autoResubscribe", "", "(Lio/kuzzle/sdk/protocol/AbstractProtocol;Z)V", "authController", "Lio/kuzzle/sdk/controllers/AuthController;", "getAuthController", "()Lio/kuzzle/sdk/controllers/AuthController;", "authenticationToken", "", "getAuthenticationToken", "()Ljava/lang/String;", "setAuthenticationToken", "(Ljava/lang/String;)V", "getAutoResubscribe", "()Z", "bulkController", "Lio/kuzzle/sdk/controllers/BulkController;", "getBulkController", "()Lio/kuzzle/sdk/controllers/BulkController;", "collectionController", "Lio/kuzzle/sdk/controllers/CollectionController;", "getCollectionController", "()Lio/kuzzle/sdk/controllers/CollectionController;", "documentController", "Lio/kuzzle/sdk/controllers/DocumentController;", "getDocumentController", "()Lio/kuzzle/sdk/controllers/DocumentController;", "indexController", "Lio/kuzzle/sdk/controllers/IndexController;", "getIndexController", "()Lio/kuzzle/sdk/controllers/IndexController;", "instanceId", "getInstanceId", "getProtocol", "()Lio/kuzzle/sdk/protocol/AbstractProtocol;", "queries", "Ljava/util/HashMap;", "Ljava/util/concurrent/CompletableFuture;", "Lio/kuzzle/sdk/coreClasses/responses/Response;", "Lkotlin/collections/HashMap;", "realtimeController", "Lio/kuzzle/sdk/controllers/RealtimeController;", "getRealtimeController", "()Lio/kuzzle/sdk/controllers/RealtimeController;", "sdkName", "serverController", "Lio/kuzzle/sdk/controllers/ServerController;", "getServerController", "()Lio/kuzzle/sdk/controllers/ServerController;", "version", "connect", "", "disconnect", "onMessageReceived", "event", "Lio/kuzzle/sdk/events/MessageReceivedEvent;", "onNetworkStateChange", "Lio/kuzzle/sdk/events/NetworkStateChangeEvent;", "onRequestError", "Lio/kuzzle/sdk/events/RequestErrorEvent;", "query", "Lio/kuzzle/sdk/coreClasses/RequestPayload;", "", "sdk-jvm"})
public class Kuzzle {
    @NotNull
    private final AbstractProtocol protocol;
    private final boolean autoResubscribe;
    @NotNull
    private final HashMap<String, CompletableFuture<Response>> queries;
    @NotNull
    private final String instanceId;
    @NotNull
    private final String version;
    @NotNull
    private final String sdkName;
    @Nullable
    private String authenticationToken;
    @NotNull
    private final RealtimeController realtimeController;
    @NotNull
    private final DocumentController documentController;
    @NotNull
    private final IndexController indexController;
    @NotNull
    private final AuthController authController;
    @NotNull
    private final ServerController serverController;
    @NotNull
    private final CollectionController collectionController;
    @NotNull
    private final BulkController bulkController;

    @NotNull
    public final AbstractProtocol getProtocol() {
        return this.protocol;
    }

    public final boolean getAutoResubscribe() {
        return this.autoResubscribe;
    }

    @NotNull
    public final String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public final String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public final void setAuthenticationToken(@Nullable String string) {
        this.authenticationToken = string;
    }

    @NotNull
    public final RealtimeController getRealtimeController() {
        return this.realtimeController;
    }

    @NotNull
    public final DocumentController getDocumentController() {
        return this.documentController;
    }

    @NotNull
    public final IndexController getIndexController() {
        return this.indexController;
    }

    @NotNull
    public final AuthController getAuthController() {
        return this.authController;
    }

    @NotNull
    public final ServerController getServerController() {
        return this.serverController;
    }

    @NotNull
    public final CollectionController getCollectionController() {
        return this.collectionController;
    }

    @NotNull
    public final BulkController getBulkController() {
        return this.bulkController;
    }

    @JvmOverloads
    public Kuzzle(@NotNull AbstractProtocol protocol, boolean autoResubscribe) {
        EventManager this_$iv;
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        this.queries = new HashMap();
        this.version = "1";
        this.sdkName = Intrinsics.stringPlus("jvm@", this.version);
        this.protocol = protocol;
        this.autoResubscribe = autoResubscribe;
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(object, "randomUUID().toString()");
        this.instanceId = object;
        this.realtimeController = new RealtimeController(this);
        this.documentController = new DocumentController(this);
        this.indexController = new IndexController(this);
        this.authController = new AuthController(this);
        this.serverController = new ServerController(this);
        this.collectionController = new CollectionController(this);
        this.bulkController = new BulkController(this);
        object = protocol;
        Function1 listener$iv = new Function1<MessageReceivedEvent, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull MessageReceivedEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Kuzzle)this.receiver).onMessageReceived(p0);
            }
        };
        boolean $i$f$addListener = false;
        this_$iv.addListener(MessageReceivedEvent.class, listener$iv);
        this_$iv = protocol;
        listener$iv = new Function1<NetworkStateChangeEvent, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull NetworkStateChangeEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Kuzzle)this.receiver).onNetworkStateChange(p0);
            }
        };
        $i$f$addListener = false;
        this_$iv.addListener(NetworkStateChangeEvent.class, listener$iv);
        this_$iv = protocol;
        listener$iv = new Function1<RequestErrorEvent, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull RequestErrorEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Kuzzle)this.receiver).onRequestError(p0);
            }
        };
        $i$f$addListener = false;
        this_$iv.addListener(RequestErrorEvent.class, listener$iv);
    }

    public /* synthetic */ Kuzzle(AbstractProtocol abstractProtocol, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(abstractProtocol, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onRequestError(RequestErrorEvent event) {
        if (event.getRequestId() != null) {
            String string = event.getRequestId();
            Intrinsics.checkNotNull(string);
            if (this.queries.get(string) != null) {
                String string2 = event.getRequestId();
                Intrinsics.checkNotNull(string2);
                CompletableFuture<Response> completableFuture = this.queries.get(string2);
                if (completableFuture != null) {
                    completableFuture.completeExceptionally(event.getException());
                }
                String string3 = event.getRequestId();
                Intrinsics.checkNotNull(string3);
                this.queries.remove(string3);
                return;
            }
        }
        this.protocol.trigger(new UnhandledExceptionEvent(event.getException()));
    }

    private final void onMessageReceived(MessageReceivedEvent event) {
        String string;
        String string2;
        String message2 = event.getMessage();
        Map<Object, Object> jsonObject = null;
        String eventRequestId = (String)event.getPayload().get("requestId");
        try {
            jsonObject = JsonSerializer.INSTANCE.deserialize(message2);
        }
        catch (Exception e) {
            if (eventRequestId != null) {
                CompletableFuture<Response> completableFuture = this.queries.get(eventRequestId);
                if (completableFuture != null) {
                    String string3 = event.getMessage();
                    if (string3 == null) {
                        string3 = "null";
                    }
                    completableFuture.completeExceptionally(new InvalidJSON(string3));
                }
                this.queries.remove(eventRequestId);
            } else {
                String string4 = event.getMessage();
                if (string4 == null) {
                    string4 = "null";
                }
                this.protocol.trigger(new UnhandledExceptionEvent(new InvalidJSON(string4)));
            }
            return;
        }
        Response response2 = new Response();
        if (!jsonObject.containsKey("requestId") && eventRequestId != null) {
            response2.setResult(jsonObject);
            response2.setRequestId(eventRequestId);
            response2.setStatus(event.getStatus());
            if (event.getHeaders() != null) {
                Map<String, List<String>> map2 = event.getHeaders();
                if (map2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String?, kotlin.Any?>");
                }
                response2.setHeaders(map2);
                Map<String, Object> map3 = response2.getHeaders();
                Intrinsics.checkNotNull(map3);
                if (map3.containsKey("X-Kuzzle-Volatile")) {
                    Map<String, Object> map4 = response2.getHeaders();
                    Intrinsics.checkNotNull(map4);
                    response2.setVolatile((Map)map4.get("X-Kuzzle-Volatile"));
                }
            }
            if (response2.getVolatile() == null) {
                response2.setVolatile((Map)event.getPayload().get("volatile"));
            }
            response2.setController((String)event.getPayload().get("controller"));
            response2.setAction((String)event.getPayload().get("action"));
            response2.setIndex((String)event.getPayload().get("index"));
            response2.setCollection((String)event.getPayload().get("collection"));
        } else {
            Response response3;
            if (!jsonObject.containsKey("headers") && event.getHeaders() != null) {
                jsonObject = MapsKt.plus(jsonObject, TuplesKt.to("headers", event.getHeaders()));
            }
            Response $this$onMessageReceived_u24lambda_u2d0 = response3 = response2;
            boolean bl = false;
            $this$onMessageReceived_u24lambda_u2d0.fromMap(jsonObject);
        }
        if ((string2 = eventRequestId) == null) {
            string2 = string = response2.getRoom();
        }
        if (string2 == null) {
            string = response2.getRequestId();
        }
        String requestId = string;
        ErrorResponse errorResponse = response2.getError();
        if (Intrinsics.areEqual(errorResponse == null ? null : errorResponse.getId(), "security.token.expired")) {
            this.protocol.trigger(new TokenExpiredEvent());
        }
        if (this.queries.isEmpty() || requestId == null || this.queries.get(requestId) == null) {
            if (response2.getError() != null) {
                this.protocol.trigger(new UnhandledExceptionEvent(new ApiErrorException(response2)));
                return;
            }
            this.protocol.trigger(new RoomMessageEvent(response2));
            return;
        }
        if (response2.getError() != null) {
            CompletableFuture<Response> completableFuture = this.queries.get(requestId);
            if (completableFuture != null) {
                completableFuture.completeExceptionally(new ApiErrorException(response2));
            }
        } else {
            CompletableFuture<Response> completableFuture = this.queries.get(requestId);
            if (completableFuture != null) {
                completableFuture.complete(response2);
            }
        }
        this.queries.remove(requestId);
    }

    private final void onNetworkStateChange(NetworkStateChangeEvent event) {
        if (event.getState() == ProtocolState.OPEN && this.autoResubscribe) {
            this.realtimeController.renewSubscriptions();
        }
    }

    public final void connect() {
        this.protocol.connect();
    }

    public final void disconnect() {
        this.protocol.disconnect();
    }

    @NotNull
    public final CompletableFuture<Response> query(@NotNull RequestPayload query2) {
        Intrinsics.checkNotNullParameter(query2, "query");
        return this.query(query2.toMap());
    }

    @NotNull
    public final CompletableFuture<Response> query(@NotNull Object query2) {
        Intrinsics.checkNotNullParameter(query2, "query");
        return this.query(JsonSerializer.INSTANCE.serialize(query2));
    }

    @NotNull
    public final CompletableFuture<Response> query(@NotNull String query2) {
        Intrinsics.checkNotNullParameter(query2, "query");
        Map<?, ?> queryMap = JsonSerializer.INSTANCE.deserialize(query2);
        return this.query(queryMap);
    }

    @NotNull
    public final CompletableFuture<Response> query(@NotNull Map<String, ? extends Object> query2) {
        Object object;
        String string;
        Map map2;
        Intrinsics.checkNotNullParameter(query2, "query");
        if (this.protocol.getState() == ProtocolState.CLOSE) {
            throw new NotConnectedException();
        }
        CompletableFuture<Response> futureRes = new CompletableFuture<Response>();
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "randomUUID().toString()");
        String requestId = string2;
        KuzzleMap queryMap = KuzzleMap.Companion.from(query2);
        if (query2.containsKey("waitForRefresh")) {
            if (Intrinsics.areEqual(query2.get("waitForRefresh"), true)) {
                map2 = queryMap;
                string = "refresh";
                object = "wait_for";
                map2.put(string, object);
            }
            queryMap.remove((Object)"waitForRefresh");
        }
        if (this.authenticationToken != null) {
            map2 = queryMap;
            string = "jwt";
            object = this.authenticationToken;
            map2.put(string, object);
        }
        ((Map)this.queries).put(requestId, futureRes);
        map2 = queryMap;
        string = "requestId";
        map2.put(string, requestId);
        if (!queryMap.containsKey((Object)"volatile") || queryMap.isNull("volatile")) {
            map2 = queryMap;
            string = "volatile";
            object = new KuzzleMap();
            map2.put(string, object);
        } else if (!queryMap.isMap("volatile")) {
            throw new Exception(KuzzleExceptionCode.WRONG_VOLATILE_TYPE.toString());
        }
        KuzzleMap kuzzleMap = queryMap.getMap("volatile");
        Intrinsics.checkNotNull(kuzzleMap);
        map2 = kuzzleMap;
        string = "sdkInstanceId";
        object = this.instanceId;
        map2.put(string, object);
        KuzzleMap kuzzleMap2 = queryMap.getMap("volatile");
        Intrinsics.checkNotNull(kuzzleMap2);
        map2 = kuzzleMap2;
        string = "sdkName";
        object = this.sdkName;
        map2.put(string, object);
        this.protocol.send(queryMap);
        return futureRes;
    }

    @JvmOverloads
    public Kuzzle(@NotNull AbstractProtocol protocol) {
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        this(protocol, false, 2, null);
    }
}

