/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "()V", "channelSetOption", "Ljava/lang/reflect/Method;", "datagramSetOption", "serverChannelSetOption", "standardSocketOptions", "", "", "Ljava/lang/reflect/Field;", "setReusePort", "", "channel", "Ljava/nio/channels/DatagramChannel;", "Ljava/nio/channels/ServerSocketChannel;", "Ljava/nio/channels/SocketChannel;", "socketOption", "name", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    @NotNull
    public static final SocketOptionsPlatformCapabilities INSTANCE;
    @NotNull
    private static final Map<String, Field> standardSocketOptions;
    @Nullable
    private static final Method channelSetOption;
    @Nullable
    private static final Method serverChannelSetOption;
    @Nullable
    private static final Method datagramSetOption;

    private SocketOptionsPlatformCapabilities() {
    }

    public final void setReusePort(@NotNull SocketChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = channelSetOption;
        Intrinsics.checkNotNull(method);
        Object[] objectArray = new Object[]{option, true};
        method.invoke((Object)channel2, objectArray);
    }

    public final void setReusePort(@NotNull ServerSocketChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = serverChannelSetOption;
        Intrinsics.checkNotNull(method);
        Object[] objectArray = new Object[]{option, true};
        method.invoke((Object)channel2, objectArray);
    }

    public final void setReusePort(@NotNull DatagramChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = datagramSetOption;
        Intrinsics.checkNotNull(method);
        Object[] objectArray = new Object[]{option, true};
        method.invoke((Object)channel2, objectArray);
    }

    private final Object socketOption(String name) {
        Field field = standardSocketOptions.get(name);
        Object object = field == null ? null : field.get(null);
        if (object == null) {
            throw new IOException("Socket option " + name + " is not supported");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int modifiers;
        Method method;
        Object element$iv;
        int n;
        int n2;
        Object[] $this$firstOrNull$iv;
        Class<?> socketChannelClass;
        GenericDeclaration socketOptionType;
        Object object;
        Object[] objectArray;
        AccessibleObject[] accessibleObjectArray;
        INSTANCE = new SocketOptionsPlatformCapabilities();
        try {
            Map map2;
            Class<?> clazz = Class.forName("java.net.StandardSocketOptions");
            if (clazz == null) {
                map2 = null;
            } else {
                accessibleObjectArray = clazz.getFields();
                if (accessibleObjectArray == null) {
                    map2 = null;
                } else {
                    void $this$associateByTo$iv$iv;
                    void $this$associateBy$iv;
                    Field element$iv$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    objectArray = accessibleObjectArray;
                    boolean $i$f$filter = false;
                    void var6_8 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    void var9_13 = $this$filterTo$iv$iv;
                    int n3 = 0;
                    int n4 = ((void)var9_13).length;
                    while (n3 < n4) {
                        element$iv$iv = var9_13[n3];
                        ++n3;
                        void it = element$iv$iv;
                        boolean bl = false;
                        int modifiers2 = it.getModifiers();
                        boolean bl2 = false;
                        boolean bl3 = Modifier.isStatic(modifiers2) && Modifier.isFinal(modifiers2) && Modifier.isPublic(modifiers2);
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    $this$filter$iv = list;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                    destination$iv$iv = $this$associateBy$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                        void it;
                        element$iv$iv = (Field)element$iv$iv2;
                        Map map3 = destination$iv$iv2;
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "it.name");
                        map3.put(string, element$iv$iv2);
                    }
                    map2 = destination$iv$iv2;
                }
            }
            object = map2;
            object = object == null ? MapsKt.emptyMap() : object;
        }
        catch (Throwable _) {
            object = MapsKt.emptyMap();
        }
        standardSocketOptions = object;
        try {
            Object object2;
            block17: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                socketChannelClass = Class.forName("java.nio.channels.SocketChannel");
                accessibleObjectArray = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue(accessibleObjectArray, "socketChannelClass.methods");
                $this$firstOrNull$iv = accessibleObjectArray;
                boolean $i$f$firstOrNull = false;
                objectArray = $this$firstOrNull$iv;
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    element$iv = objectArray[n2];
                    ++n2;
                    method = (Method)element$iv;
                    boolean bl = false;
                    modifiers = method.getModifiers();
                    boolean bl4 = false;
                    boolean bl5 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method.getName(), "setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl5) continue;
                    object2 = element$iv;
                    break block17;
                }
                object2 = null;
            }
            socketOptionType = (Method)object2;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        channelSetOption = socketOptionType;
        try {
            Object object3;
            block18: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                socketChannelClass = Class.forName("java.nio.channels.ServerSocketChannel");
                $this$firstOrNull$iv = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue($this$firstOrNull$iv, "socketChannelClass.methods");
                boolean $i$f$firstOrNull = false;
                objectArray = $this$firstOrNull$iv;
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    element$iv = objectArray[n2];
                    ++n2;
                    method = (Method)element$iv;
                    boolean bl = false;
                    modifiers = method.getModifiers();
                    boolean bl6 = false;
                    boolean bl7 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method.getName(), "setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl7) continue;
                    object3 = element$iv;
                    break block18;
                }
                object3 = null;
            }
            socketOptionType = (Method)object3;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        serverChannelSetOption = socketOptionType;
        try {
            Object object4;
            block19: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                socketChannelClass = Class.forName("java.nio.channels.DatagramChannel");
                $this$firstOrNull$iv = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue($this$firstOrNull$iv, "socketChannelClass.methods");
                boolean $i$f$firstOrNull = false;
                objectArray = $this$firstOrNull$iv;
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    element$iv = objectArray[n2];
                    ++n2;
                    method = (Method)element$iv;
                    boolean bl = false;
                    modifiers = method.getModifiers();
                    boolean bl8 = false;
                    boolean bl9 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method.getName(), "setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl9) continue;
                    object4 = element$iv;
                    break block19;
                }
                object4 = null;
            }
            object = (Method)object4;
        }
        catch (Throwable _) {
            object = null;
        }
        datagramSetOption = object;
    }
}

