/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.kuzzle.sdk.coreClasses.RequestPayload;
import io.kuzzle.sdk.coreClasses.json.MapTypeAdapter;
import io.kuzzle.sdk.coreClasses.json.RawJson;
import io.kuzzle.sdk.coreClasses.json.RequestTypeAdapter;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0001R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kuzzle/sdk/coreClasses/json/JsonSerializer;", "", "()V", "gson", "Lcom/google/gson/Gson;", "deserialize", "", "rawJson", "", "serialize", "obj", "sdk-jvm"})
public final class JsonSerializer {
    @NotNull
    public static final JsonSerializer INSTANCE = new JsonSerializer();
    @Nullable
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().disableInnerClassSerialization().serializeNulls().registerTypeAdapter((Type)((Object)Map.class), (Object)new MapTypeAdapter()).registerTypeAdapter((Type)((Object)RequestPayload.class), (Object)new RequestTypeAdapter()).create();

    private JsonSerializer() {
    }

    @NotNull
    public final Map<?, ?> deserialize(@Nullable String rawJson) {
        Map map;
        if (rawJson == null || StringsKt.isBlank((CharSequence)rawJson)) {
            map = new KuzzleMap();
        } else {
            Gson gson = JsonSerializer.gson;
            Intrinsics.checkNotNull((Object)gson);
            Object object = gson.fromJson(rawJson, Map.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            gson!!.fro\u2026ap::class.java)\n        }");
            map = (Map)object;
        }
        return map;
    }

    @NotNull
    public final String serialize(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof Map) {
            Gson gson = JsonSerializer.gson;
            Intrinsics.checkNotNull((Object)gson);
            String string = gson.toJson(obj, (Type)((Object)Map.class));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson!!.toJson(obj, Map::class.java)");
            return string;
        }
        if (obj instanceof RawJson) {
            return ((RawJson)obj).getRawJson();
        }
        Gson gson = JsonSerializer.gson;
        Intrinsics.checkNotNull((Object)gson);
        String string = gson.toJson(obj);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson!!.toJson(obj)");
        return string;
    }
}

