/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.http;

import io.kuzzle.sdk.coreClasses.exceptions.MissingURLParamException;
import io.kuzzle.sdk.coreClasses.http.HttpRequest;
import io.kuzzle.sdk.coreClasses.http.PartType;
import io.kuzzle.sdk.coreClasses.http.RouteKt;
import io.kuzzle.sdk.coreClasses.http.RoutePart;
import io.kuzzle.sdk.coreClasses.json.JsonSerializer;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import io.kuzzle.sdk.coreClasses.serializer.StringSerializer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/kuzzle/sdk/coreClasses/http/Route;", "", "verb", "", "baseUrl", "routeParts", "Ljava/util/ArrayList;", "Lio/kuzzle/sdk/coreClasses/http/RoutePart;", "Lkotlin/collections/ArrayList;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;)V", "baseURL", "partType", "Lio/kuzzle/sdk/coreClasses/http/PartType;", "staticURL", "buildRequest", "Lio/kuzzle/sdk/coreClasses/http/HttpRequest;", "request", "Lio/kuzzle/sdk/coreClasses/maps/KuzzleMap;", "getBody", "Companion", "sdk-jvm"})
public final class Route {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartType partType;
    @NotNull
    private final ArrayList<RoutePart> routeParts;
    @NotNull
    private String staticURL;
    @NotNull
    private String baseURL;
    @NotNull
    private String verb;

    private Route(String verb, String baseUrl, ArrayList<RoutePart> routeParts) {
        int n;
        block3: {
            this.staticURL = "";
            String string = verb.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            this.verb = string;
            this.baseURL = baseUrl;
            this.routeParts = routeParts;
            List $this$indexOfFirst$iv = routeParts;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                RoutePart it = (RoutePart)item$iv;
                boolean bl = false;
                if (it.getType() == PartType.TEMPLATE) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        boolean hasOnePartTemplated = n > -1;
        PartType partType = this.partType = hasOnePartTemplated ? PartType.TEMPLATE : PartType.STATIC;
        if (!hasOnePartTemplated) {
            this.staticURL = CollectionsKt.joinToString$default((Iterable)routeParts, (CharSequence)"", null, null, (int)0, null, (Function1)1.INSTANCE, (int)30, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequest buildRequest(@NotNull KuzzleMap request) {
        void $this$filterTo$iv$iv;
        Map<?, ?> body;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KuzzleMap headers = request.optMap("headers", new KuzzleMap());
        KuzzleMap queryArgs = new KuzzleMap();
        block14: for (String key : request.keySet()) {
            if (key == null || request.get((Object)key) == null) continue;
            switch (key) {
                case "jwt": {
                    Map map = headers;
                    String string = "authorization";
                    Object object = Intrinsics.stringPlus((String)"Bearer ", (Object)request.get((Object)"jwt"));
                    map.put(string, object);
                    continue block14;
                }
                case "volatile": {
                    Map map = headers;
                    String string = "x-kuzzle-volatile";
                    Object object = request.get((Object)"volatile");
                    map.put(string, object);
                    continue block14;
                }
                case "requestId": {
                    Map map = headers;
                    String string = "x-kuzzle-request-id";
                    Object object = request.get((Object)"requestId");
                    map.put(string, object);
                    continue block14;
                }
                case "headers": {
                    headers.putAll(request.optMap("headers", new KuzzleMap()));
                    continue block14;
                }
                case "body": {
                    if (!Intrinsics.areEqual((Object)this.verb, (Object)"GET") || (body = request.get((Object)"body")) == null) continue block14;
                    if (!(body instanceof Map)) {
                        body = JsonSerializer.INSTANCE.deserialize(JsonSerializer.INSTANCE.serialize(body));
                    }
                    Map<?, ?> map = body;
                    if (map == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String?, kotlin.Any?>");
                    }
                    queryArgs.putAll((Map)map);
                    continue block14;
                }
            }
            if (RouteKt.getPayloadProperties().contains(key)) continue;
            body = queryArgs;
            Object object = request.get((Object)key);
            body.put(key, object);
        }
        Map $this$filter$iv = queryArgs;
        boolean $i$f$filter = false;
        body = $this$filter$iv;
        Map map = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(it.getKey() != null && it.getValue() != null)) continue;
            map.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        String queryString2 = CollectionsKt.joinToString$default((Iterable)map.keySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(queryArgs){
            final /* synthetic */ KuzzleMap $queryArgs;
            {
                this.$queryArgs = $queryArgs;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@Nullable String it) {
                CharSequence charSequence;
                String encodedKey = URLEncoder.encode(it, "utf-8");
                String string = it;
                Intrinsics.checkNotNull((Object)string);
                if (Intrinsics.areEqual((Object)this.$queryArgs.optBoolean(string, false), (Object)true)) {
                    String string2 = encodedKey;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                encodedKey\n            }");
                    charSequence = string2;
                } else {
                    Object object = this.$queryArgs.get((Object)it);
                    Intrinsics.checkNotNull((Object)object);
                    String value = StringSerializer.INSTANCE.serialize(object);
                    charSequence = encodedKey + '=' + URLEncoder.encode(value, "utf-8");
                }
                return charSequence;
            }
        }), (int)30, null);
        if (this.partType == PartType.STATIC) {
            return new HttpRequest(this.verb, queryArgs.isEmpty() ? this.staticURL : this.staticURL + '?' + queryString2, !Intrinsics.areEqual((Object)this.verb, (Object)"GET") ? this.getBody(request) : null, headers);
        }
        StringBuilder urlBuilder = new StringBuilder();
        for (RoutePart routePart : this.routeParts) {
            Intrinsics.checkNotNullExpressionValue((Object)routePart, (String)"routeParts");
            RoutePart routePart2 = routePart;
            if (routePart2.getType() == PartType.STATIC) {
                urlBuilder.append(routePart2.getValue());
                continue;
            }
            if (!request.containsKey((Object)routePart2.getValue()) || request.get((Object)routePart2.getValue()) == null) {
                throw new MissingURLParamException(routePart2.getValue(), this.baseURL);
            }
            Object object = request.get((Object)routePart2.getValue());
            Intrinsics.checkNotNull((Object)object);
            String string = object.toString();
            urlBuilder.append(URLEncoder.encode(string, "utf-8"));
        }
        String string = queryArgs.isEmpty() ? urlBuilder.toString() : urlBuilder + '?' + queryString2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (queryArgs.isEmpty())\u2026$urlBuilder?$queryString\"");
        return new HttpRequest(this.verb, string, !Intrinsics.areEqual((Object)this.verb, (Object)"GET") ? this.getBody(request) : null, headers);
    }

    private final KuzzleMap getBody(KuzzleMap request) {
        Object body = request.get((Object)"body");
        return body == null ? new KuzzleMap() : (!(body instanceof Map) ? KuzzleMap.Companion.from(JsonSerializer.INSTANCE.deserialize(JsonSerializer.INSTANCE.serialize(body))) : KuzzleMap.Companion.from((Map)body));
    }

    public /* synthetic */ Route(String verb, String baseUrl, ArrayList routeParts, DefaultConstructorMarker $constructor_marker) {
        this(verb, baseUrl, routeParts);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lio/kuzzle/sdk/coreClasses/http/Route$Companion;", "", "()V", "parse", "Lio/kuzzle/sdk/coreClasses/http/Route;", "verb", "", "url", "sdk-jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Route parse(@NotNull String verb, @NotNull String url) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            ArrayList<RoutePart> routeParts = new ArrayList<RoutePart>();
            Object object = new char[]{'/'};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)url, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List parts = (List)destination$iv$iv;
            routeParts.add(new RoutePart(PartType.STATIC, "/"));
            object = parts.iterator();
            while (object.hasNext()) {
                String part = (String)object.next();
                if (StringsKt.startsWith$default((String)part, (String)":", (boolean)false, (int)2, null)) {
                    String string = part.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    routeParts.add(new RoutePart(PartType.TEMPLATE, string));
                } else {
                    routeParts.add(new RoutePart(PartType.STATIC, part));
                }
                routeParts.add(new RoutePart(PartType.STATIC, "/"));
            }
            if (!StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                CollectionsKt.removeLast((List)routeParts);
            }
            return new Route(verb, url, routeParts, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

