/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.json;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.kuzzle.sdk.coreClasses.json.JsonSerializer;
import io.kuzzle.sdk.coreClasses.json.RawJson;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lio/kuzzle/sdk/coreClasses/json/MapTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "", "", "", "()V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "map", "Companion", "sdk-jvm"})
public final class MapTypeAdapter
extends TypeAdapter<Map<String, ? extends Object>> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void write(@NotNull JsonWriter out2, @Nullable Map<String, ? extends Object> map2) throws IOException {
        Intrinsics.checkNotNullParameter(out2, "out");
        if (map2 == null) {
            out2.nullValue();
        } else {
            out2.beginObject();
            for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
                out2.name(entry.getKey());
                Companion.writeObject(out2, entry.getValue());
            }
            out2.endObject();
        }
    }

    @Override
    @Nullable
    public Map<String, Object> read(@NotNull JsonReader in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.BEGIN_OBJECT) {
            KuzzleMap map2 = new KuzzleMap();
            String key = null;
            Object value = null;
            in.beginObject();
            while (in.hasNext()) {
                String string = in.nextName();
                Intrinsics.checkNotNullExpressionValue(string, "`in`.nextName()");
                key = string;
                value = Companion.readObject(in);
                if (!map2.containsKey((Object)key)) {
                    map2.put(key, value);
                    continue;
                }
                throw new JsonSyntaxException(Intrinsics.stringPlus("duplicate key: ", key));
            }
            in.endObject();
            return map2;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u000b"}, d2={"Lio/kuzzle/sdk/coreClasses/json/MapTypeAdapter$Companion;", "", "()V", "readObject", "in", "Lcom/google/gson/stream/JsonReader;", "writeObject", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "sdk-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeObject(@NotNull JsonWriter out2, @Nullable Object value) throws IOException {
            Intrinsics.checkNotNullParameter(out2, "out");
            if (value instanceof Number) {
                out2.value((Number)value);
            } else if (value instanceof Boolean) {
                out2.value((Boolean)value);
            } else if (value instanceof String) {
                out2.value((String)value);
            } else if (value instanceof ArrayList) {
                out2.beginArray();
                Iterator iterator2 = ((ArrayList)value).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "value as ArrayList<Any?>).iterator()");
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    this.writeObject(out2, iterator3.next());
                }
                out2.endArray();
            } else if (value instanceof Map) {
                out2.beginObject();
                for (Map.Entry e : ((Map)value).entrySet()) {
                    out2.name((String)e.getKey());
                    this.writeObject(out2, e.getValue());
                }
                out2.endObject();
            } else if (value instanceof RawJson) {
                out2.jsonValue(((RawJson)value).getRawJson());
            } else if (value == null) {
                out2.nullValue();
            } else {
                out2.jsonValue(JsonSerializer.INSTANCE.serialize(value));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Object readObject(@NotNull JsonReader in) throws IOException {
            Serializable serializable;
            Intrinsics.checkNotNullParameter(in, "in");
            JsonToken jsonToken = in.peek();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    String number = in.nextString();
                    serializable = new LazilyParsedNumber(number);
                    break;
                }
                case 2: {
                    serializable = Boolean.valueOf(in.nextBoolean());
                    break;
                }
                case 3: {
                    serializable = (Serializable)((Object)in.nextString());
                    break;
                }
                case 4: {
                    in.nextNull();
                    serializable = null;
                    break;
                }
                case 5: {
                    ArrayList<Object> array = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.add(this.readObject(in));
                    }
                    in.endArray();
                    serializable = array;
                    break;
                }
                case 6: {
                    void var2_4;
                    KuzzleMap map2 = new KuzzleMap();
                    in.beginObject();
                    while (in.hasNext()) {
                        String key = in.nextName();
                        Object object = this.readObject(in);
                        if (object == null) continue;
                        Intrinsics.checkNotNullExpressionValue(key, "key");
                        map2.put(key, object);
                    }
                    in.endObject();
                    serializable = (Serializable)var2_4;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return serializable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonToken.values().length];
                nArray[JsonToken.NUMBER.ordinal()] = 1;
                nArray[JsonToken.BOOLEAN.ordinal()] = 2;
                nArray[JsonToken.STRING.ordinal()] = 3;
                nArray[JsonToken.NULL.ordinal()] = 4;
                nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 5;
                nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 6;
                nArray[JsonToken.END_DOCUMENT.ordinal()] = 7;
                nArray[JsonToken.NAME.ordinal()] = 8;
                nArray[JsonToken.END_OBJECT.ordinal()] = 9;
                nArray[JsonToken.END_ARRAY.ordinal()] = 10;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

