/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.AbstractInput;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BufferPrimitivesKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.ExperimentalIoApi;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.core.internal.CharArraySequence;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u001a0\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a,\u0010\b\u001a\u00020\u0011*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0007\u001a0\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a0\u0010\u0013\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a,\u0010\u0016\u001a\u00020\u0017*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0007\u001a,\u0010\u0018\u001a\u00020\u0017*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0000\u001a0\u0010\u0019\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u0011*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u0011H\u0007\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0005H\u0000\u00a8\u0006\u001e"}, d2={"decode", "", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "input", "Lio/ktor/utils/io/core/Input;", "max", "", "encode", "", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "", "fromIndex", "toIndex", "dst", "Lio/ktor/utils/io/core/Output;", "Lio/ktor/utils/io/core/ByteReadPacket;", "", "encodeArrayImpl", "Lio/ktor/utils/io/core/Buffer;", "encodeCompleteImpl", "encodeToByteArrayImpl", "", "encodeToByteArrayImpl1", "encodeToImpl", "destination", "encodeUTF8", "sizeEstimate", "", "ktor-io"})
public final class EncodingKt {
    @Deprecated(message="Use writeText on Output instead.", replaceWith=@ReplaceWith(expression="dst.writeText(input, fromIndex, toIndex, charset)", imports={"io.ktor.utils.io.core.writeText"}))
    public static final void encode(@NotNull CharsetEncoder $this$encode, @NotNull CharSequence input2, int fromIndex, int toIndex, @NotNull Output dst) {
        Intrinsics.checkNotNullParameter($this$encode, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(dst, "dst");
        EncodingKt.encodeToImpl($this$encode, dst, input2, fromIndex, toIndex);
    }

    @Deprecated(message="Internal API. Will be hidden in future releases. Use encodeToByteArray instead.", replaceWith=@ReplaceWith(expression="encodeToByteArray(input, fromIndex, toIndex)", imports={}))
    @NotNull
    public static final byte[] encodeToByteArrayImpl(@NotNull CharsetEncoder $this$encodeToByteArrayImpl, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$encodeToByteArrayImpl, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        return CharsetJVMKt.encodeToByteArray($this$encodeToByteArrayImpl, input2, fromIndex, toIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArrayImpl$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encodeToByteArrayImpl(charsetEncoder, charSequence, n, n2);
    }

    @ExperimentalIoApi
    @NotNull
    public static final ByteReadPacket encode(@NotNull CharsetEncoder $this$encode, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$encode, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$encode_u24lambda_u2d0 = builder$iv;
            boolean bl = false;
            EncodingKt.encodeToImpl($this$encode, $this$encode_u24lambda_u2d0, input2, fromIndex, toIndex);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    public static /* synthetic */ ByteReadPacket encode$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encode(charsetEncoder, charSequence, n, n2);
    }

    @ExperimentalIoApi
    @NotNull
    public static final ByteReadPacket encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$encodeUTF8, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$encodeUTF8_u24lambda_u2d1 = builder$iv;
            boolean bl = false;
            CharsetJVMKt.encodeUTF8($this$encodeUTF8, input2, $this$encodeUTF8_u24lambda_u2d1);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ExperimentalIoApi
    public static final void encode(@NotNull CharsetEncoder $this$encode, @NotNull char[] input2, int fromIndex, int toIndex, @NotNull Output dst) {
        void $this$writeWhileSize$iv;
        Intrinsics.checkNotNullParameter($this$encode, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(dst, "dst");
        int start2 = 0;
        start2 = fromIndex;
        if (start2 >= toIndex) {
            return;
        }
        Output output2 = dst;
        int initialSize$iv = 1;
        boolean $i$f$writeWhileSize = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, initialSize$iv, null);
        try {
            int size$iv = 0;
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                int rc2 = EncodingKt.encodeArrayImpl($this$encode, input2, start2, toIndex, view);
                if (!(rc2 >= 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                size$iv = (start2 += rc2) >= toIndex ? 0 : (rc2 == 0 ? 8 : 1);
                if (size$iv <= 0) {
                    break;
                }
                tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, size$iv, tail$iv);
            }
        }
        finally {
            UnsafeKt.afterHeadWrite((Output)$this$writeWhileSize$iv, tail$iv);
        }
        EncodingKt.encodeCompleteImpl($this$encode, dst);
    }

    @ExperimentalIoApi
    @NotNull
    public static final String decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input2, int max) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$decode, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        int n = (int)Math.min((long)max, EncodingKt.sizeEstimate(input2));
        StringBuilder $this$decode_u24lambda_u2d3 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        CharsetJVMKt.decode($this$decode, input2, $this$decode_u24lambda_u2d3, max);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String decode$default(CharsetDecoder charsetDecoder, Input input2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return EncodingKt.decode(charsetDecoder, input2, n);
    }

    public static final int encodeArrayImpl(@NotNull CharsetEncoder $this$encodeArrayImpl, @NotNull char[] input2, int fromIndex, int toIndex, @NotNull Buffer dst) {
        Intrinsics.checkNotNullParameter($this$encodeArrayImpl, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(dst, "dst");
        int length = toIndex - fromIndex;
        return CharsetJVMKt.encodeImpl($this$encodeArrayImpl, new CharArraySequence(input2, fromIndex, length), 0, length, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] encodeToByteArrayImpl1(@NotNull CharsetEncoder $this$encodeToByteArrayImpl1, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$encodeToByteArrayImpl1, "<this>");
        Intrinsics.checkNotNullParameter(input2, "input");
        int start2 = 0;
        start2 = fromIndex;
        if (start2 >= toIndex) {
            return UnsafeKt.EmptyByteArray;
        }
        ChunkBuffer single2 = ChunkBuffer.Companion.getPool().borrow();
        try {
            ByteReadPacket byteReadPacket;
            int rc2 = CharsetJVMKt.encodeImpl($this$encodeToByteArrayImpl1, input2, start2, toIndex, single2);
            if ((start2 += rc2) == toIndex) {
                Object this_$iv = single2;
                boolean $i$f$getReadRemaining = false;
                byte[] result2 = new byte[((Buffer)this_$iv).getWritePosition() - ((Buffer)this_$iv).getReadPosition()];
                BufferPrimitivesKt.readFully$default((Buffer)single2, result2, 0, 0, 6, null);
                this_$iv = result2;
                return this_$iv;
            }
            int headerSizeHint$iv = 0;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
            try {
                BytePacketBuilder $this$encodeToByteArrayImpl1_u24lambda_u2d4 = builder$iv;
                boolean bl = false;
                $this$encodeToByteArrayImpl1_u24lambda_u2d4.appendSingleChunk$ktor_io(single2.duplicate());
                EncodingKt.encodeToImpl($this$encodeToByteArrayImpl1, $this$encodeToByteArrayImpl1_u24lambda_u2d4, input2, start2, toIndex);
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            byte[] byArray = StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
            return byArray;
        }
        finally {
            single2.release(ChunkBuffer.Companion.getPool());
        }
    }

    public static /* synthetic */ byte[] encodeToByteArrayImpl1$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encodeToByteArrayImpl1(charsetEncoder, charSequence, n, n2);
    }

    public static final long sizeEstimate(@NotNull Input $this$sizeEstimate) {
        Intrinsics.checkNotNullParameter($this$sizeEstimate, "<this>");
        Input input2 = $this$sizeEstimate;
        return input2 instanceof ByteReadPacket ? ((ByteReadPacket)$this$sizeEstimate).getRemaining() : (input2 instanceof AbstractInput ? Math.max(((AbstractInput)$this$sizeEstimate).getRemaining(), 16L) : 16L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int encodeCompleteImpl(CharsetEncoder $this$encodeCompleteImpl, Output dst) {
        int size2 = 0;
        size2 = 1;
        int bytesWritten = 0;
        Output $this$writeWhile$iv = dst;
        boolean $i$f$writeWhile = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhile$iv, 1, null);
        try {
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                Buffer this_$iv2 = view;
                boolean $i$f$getWriteRemaining = false;
                int before = this_$iv2.getLimit() - this_$iv2.getWritePosition();
                if (CharsetJVMKt.encodeComplete($this$encodeCompleteImpl, view)) {
                    size2 = 0;
                } else {
                    int this_$iv2 = size2;
                    size2 = this_$iv2 + 1;
                }
                this_$iv2 = view;
                $i$f$getWriteRemaining = false;
                bytesWritten += before - (this_$iv2.getLimit() - this_$iv2.getWritePosition());
                if (!(size2 > 0)) {
                    break;
                }
                tail$iv = UnsafeKt.prepareWriteHead($this$writeWhile$iv, 1, tail$iv);
            }
        }
        finally {
            UnsafeKt.afterHeadWrite($this$writeWhile$iv, tail$iv);
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int encodeToImpl(@NotNull CharsetEncoder $this$encodeToImpl, @NotNull Output destination, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        void $this$writeWhileSize$iv;
        Intrinsics.checkNotNullParameter($this$encodeToImpl, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(input2, "input");
        int start2 = 0;
        start2 = fromIndex;
        if (start2 >= toIndex) {
            return 0;
        }
        int bytesWritten = 0;
        Output output2 = destination;
        int initialSize$iv = 1;
        boolean $i$f$writeWhileSize = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, initialSize$iv, null);
        try {
            int size$iv = 0;
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                Buffer this_$iv = view;
                boolean $i$f$getWriteRemaining = false;
                int before = this_$iv.getLimit() - this_$iv.getWritePosition();
                int rc2 = CharsetJVMKt.encodeImpl($this$encodeToImpl, input2, start2, toIndex, view);
                if (!(rc2 >= 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Buffer this_$iv2 = view;
                boolean $i$f$getWriteRemaining2 = false;
                bytesWritten += before - (this_$iv2.getLimit() - this_$iv2.getWritePosition());
                size$iv = (start2 += rc2) >= toIndex ? 0 : (rc2 == 0 ? 8 : 1);
                if (size$iv <= 0) {
                    break;
                }
                tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, size$iv, tail$iv);
            }
        }
        finally {
            UnsafeKt.afterHeadWrite((Output)$this$writeWhileSize$iv, tail$iv);
        }
        return bytesWritten += EncodingKt.encodeCompleteImpl($this$encodeToImpl, destination);
    }
}

