/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.BytePacketUtilsKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EMPTY_CHUNK", "", "PADDED_EMPTY_CHUNK", "deflateFully", "Ljava/util/zip/Deflater;", "data", "deflateTo", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "deflater", "buffer", "Ljava/nio/ByteBuffer;", "flush", "", "inflateFully", "Ljava/util/zip/Inflater;", "ktor-http-cio"})
public final class DeflaterUtilsKt {
    @NotNull
    private static final byte[] PADDED_EMPTY_CHUNK;
    @NotNull
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkNotNullParameter($this$deflateFully, "<this>");
        Intrinsics.checkNotNullParameter(data2, "data");
        $this$deflateFully.setInput(data2);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u2d1 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                while (!$this$deflateFully.needsInput()) {
                    DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u2d1, $this$deflateFully, buffer, false);
                }
                while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u2d1, $this$deflateFully, buffer, true) != 0) {
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket deflatedBytes = byteReadPacket2;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] it = headerSizeHint$iv = StringsKt.readBytes(deflatedBytes, (int)deflatedBytes.getRemaining() - EMPTY_CHUNK.length);
            boolean bl = false;
            deflatedBytes.release();
            return headerSizeHint$iv;
        }
        headerSizeHint$iv = 0;
        $i$f$buildPacket = false;
        builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u2d3 = builder$iv;
            boolean bl = false;
            $this$deflateFully_u24lambda_u2d3.writePacket(deflatedBytes);
            $this$deflateFully_u24lambda_u2d3.writeByte((byte)0);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$inflateFully, "<this>");
        Intrinsics.checkNotNullParameter(data2, "data");
        byte[] dataToInflate = ArraysKt.plus(data2, EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$inflateFully_u24lambda_u2d5 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
                while ($this$inflateFully.getBytesRead() < limit) {
                    buffer.clear();
                    int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                    buffer.position(buffer.position() + inflated);
                    buffer.flip();
                    OutputArraysJVMKt.writeFully($this$inflateFully_u24lambda_u2d5, buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        return StringsKt.readBytes$default(packet2, 0, 1, null);
    }

    private static final int deflateTo(BytePacketBuilder $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated2;
        buffer.clear();
        int n = deflated2 = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated2 == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated2);
        buffer.flip();
        OutputArraysJVMKt.writeFully($this$deflateTo, buffer);
        return deflated2;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1};
        PADDED_EMPTY_CHUNK = byArray;
        byArray = new byte[]{0, 0, -1, -1};
        EMPTY_CHUNK = byArray;
    }
}

